/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Set;
import org.nuxeo.client.marshaller.DocTypeSchemaDeserializer;
import org.nuxeo.client.methods.ConfigAPI;
import org.nuxeo.client.objects.ConnectableEntity;
import org.nuxeo.client.objects.config.DocType$$Lambda$1;
import org.nuxeo.client.objects.config.Schema;

public class DocType
extends ConnectableEntity<ConfigAPI, DocType> {
    protected String name;
    protected String parent;
    protected Set<String> facets;
    @JsonDeserialize(using=DocTypeSchemaDeserializer.class)
    protected List<Schema> schemas;
    @JsonIgnore
    protected DocType parentType;

    protected DocType() {
        super("docType", ConfigAPI.class);
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public Set<String> getFacets() {
        return this.facets;
    }

    public boolean hasFacet(String facet) {
        return this.facets.contains(facet);
    }

    public List<Schema> getSchemas() {
        return this.schemas;
    }

    public Schema getSchema(String name) {
        return this.schemas.stream().filter(DocType$$Lambda$1.lambdaFactory$(name)).findAny().orElse(null);
    }

    public DocType fetchParent() {
        if (this.parentType == null) {
            this.parentType = this.fetchResponse(((ConfigAPI)this.api).type(this.parent));
        }
        return this.parentType;
    }

    static /* synthetic */ boolean lambda$getSchema$0(String name, Schema schema) {
        return schema.getName().equals(name);
    }
}

