/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DecimalFormatCache {
    private static final String BASE_FORMAT = "0.################";
    private static final ThreadLocal[] DECIMAL_FORMAT_CACHE = new DecimalFormatThreadLocal[17];

    public static DecimalFormat getDecimalFormat(int dec) {
        if (dec < 0 || dec >= DECIMAL_FORMAT_CACHE.length) {
            throw new IllegalArgumentException("Parameter dec must be between 1 and " + (DECIMAL_FORMAT_CACHE.length + 1));
        }
        return (DecimalFormat)DECIMAL_FORMAT_CACHE[dec].get();
    }

    static {
        int c = DECIMAL_FORMAT_CACHE.length;
        for (int i = 0; i < c; ++i) {
            DecimalFormatCache.DECIMAL_FORMAT_CACHE[i] = new DecimalFormatThreadLocal(i);
        }
    }

    private static class DecimalFormatThreadLocal
    extends ThreadLocal {
        private int dec;

        public DecimalFormatThreadLocal(int dec) {
            this.dec = dec;
        }

        protected synchronized Object initialValue() {
            String s = "0";
            if (this.dec > 0) {
                s = DecimalFormatCache.BASE_FORMAT.substring(0, this.dec + 2);
            }
            DecimalFormat df = new DecimalFormat(s, new DecimalFormatSymbols(Locale.US));
            return df;
        }
    }
}

