/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.alfresco;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import org.alfresco.webservice.authentication.AuthenticationFault;
import org.alfresco.webservice.content.Content;
import org.alfresco.webservice.content.ContentFault;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.util.AuthenticationDetails;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.ContentUtils;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.manifoldcf.crawler.system.Logging;

public class ContentReader {
    public static Content read(String endpoint, String username, String password, int socketTimeout, AuthenticationDetails session, Predicate predicate, String contentProperty) throws IOException {
        Content[] resultBinary = null;
        try {
            WebServiceFactory.setEndpointAddress((String)endpoint);
            WebServiceFactory.setTimeoutMilliseconds((int)socketTimeout);
            AuthenticationUtils.startSession((String)username, (String)password);
            session = AuthenticationUtils.getAuthenticationDetails();
            resultBinary = WebServiceFactory.getContentService().read(predicate, contentProperty);
            AuthenticationUtils.endSession();
        }
        catch (ContentFault e) {
            Logging.connectors.error((Object)("Alfresco: Content fault exception error during getting the content binary in processDocuments. Node: " + predicate.getNodes()[0].getPath() + ". " + e.getMessage()), (Throwable)e);
            throw new IOException("Alfresco: Content fault exception error during getting the content binary in processDocuments. Node: " + predicate.getNodes()[0].getPath() + ". " + e.getMessage(), e);
        }
        catch (RemoteException e) {
            Logging.connectors.error((Object)("Alfresco: Remote exception error during getting the content binary in processDocuments. Node: " + predicate.getNodes()[0].getPath() + ". " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            session = null;
        }
        return resultBinary[0];
    }

    public static InputStream getBinary(String endpoint, Content binary, String username, String password, int socketTimeout, AuthenticationDetails session) throws IOException {
        InputStream is = null;
        try {
            WebServiceFactory.setEndpointAddress((String)endpoint);
            WebServiceFactory.setTimeoutMilliseconds((int)socketTimeout);
            AuthenticationUtils.startSession((String)username, (String)password);
            session = AuthenticationUtils.getAuthenticationDetails();
            is = ContentUtils.getContentAsInputStream((Content)binary);
        }
        catch (AuthenticationFault e) {
            Logging.connectors.error((Object)("Alfresco: Error during getting the binary for the node: " + binary.getNode().getPath() + "." + e.getMessage()), (Throwable)e);
            throw e;
        }
        return is;
    }
}

