/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.system.SystemListener;

public abstract class TypeRegistration {
    public static final String ROOT_ADAPTERS = "org.apache.sis.xml.rootAdapters";
    private static Reference<JAXBContext> context;
    private static UnaryOperator<Object>[] converters;
    private static ServiceLoader<TypeRegistration> services;

    protected TypeRegistration() {
    }

    protected abstract void getTypes(Collection<Class<?>> var1);

    protected UnaryOperator<Object> beforeMarshal() {
        return null;
    }

    protected boolean hasRenameFile(boolean bl) {
        return false;
    }

    public static synchronized void getRenameFileLoader(boolean bl, Set<Class<?>> set) {
        for (TypeRegistration typeRegistration : TypeRegistration.services()) {
            if (!typeRegistration.hasRenameFile(bl)) continue;
            set.add(typeRegistration.getClass());
        }
    }

    private static ServiceLoader<TypeRegistration> services() {
        ServiceLoader<TypeRegistration> serviceLoader = services;
        if (serviceLoader == null) {
            services = serviceLoader = DefaultFactories.createServiceLoader(TypeRegistration.class);
            DelayedExecutor.schedule(new DelayedRunnable(1, TimeUnit.MINUTES){

                @Override
                public void run() {
                    services = null;
                }
            });
        }
        return serviceLoader;
    }

    private static Class<?>[] load(boolean bl) {
        ArrayList arrayList = new ArrayList();
        ArrayList<UnaryOperator<Object>> arrayList2 = new ArrayList<UnaryOperator<Object>>();
        for (TypeRegistration typeRegistration : TypeRegistration.services()) {
            UnaryOperator<Object> unaryOperator;
            if (bl) {
                typeRegistration.getTypes(arrayList);
            }
            if ((unaryOperator = typeRegistration.beforeMarshal()) == null) continue;
            arrayList2.add(unaryOperator);
        }
        converters = arrayList2.toArray(new UnaryOperator[arrayList2.size()]);
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public static synchronized JAXBContext getSharedContext() throws JAXBException {
        JAXBContext jAXBContext;
        Reference<JAXBContext> reference = context;
        if (reference != null && (jAXBContext = reference.get()) != null) {
            return jAXBContext;
        }
        jAXBContext = JAXBContext.newInstance((Class[])TypeRegistration.load(true));
        context = new WeakReference<JAXBContext>(jAXBContext);
        return jAXBContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ?> getPrivateInfo(Map<String, ?> map) {
        if (map != null && map.containsKey(ROOT_ADAPTERS)) {
            return map;
        }
        Object object = TypeRegistration.class;
        synchronized (TypeRegistration.class) {
            UnaryOperator<Object>[] unaryOperatorArray = converters;
            if (unaryOperatorArray == null) {
                TypeRegistration.load(false);
                unaryOperatorArray = converters;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (map == null) {
                return Collections.singletonMap(ROOT_ADAPTERS, unaryOperatorArray);
            }
            object = new HashMap(map);
            object.put(ROOT_ADAPTERS, unaryOperatorArray);
            return object;
        }
    }

    static /* synthetic */ UnaryOperator[] access$102(UnaryOperator[] unaryOperatorArray) {
        converters = unaryOperatorArray;
        return unaryOperatorArray;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.util"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void classpathChanged() {
                Class<TypeRegistration> clazz = TypeRegistration.class;
                synchronized (TypeRegistration.class) {
                    context = null;
                    TypeRegistration.access$102(null);
                    services = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

