/*
 * Decompiled with CFR 0.152.
 */
package icc.lut;

import icc.lut.LookUpTableFP;
import icc.tags.ICCCurveType;

public class LookUpTableFPInterp
extends LookUpTableFP {
    public String toString() {
        StringBuffer rep = new StringBuffer("[LookUpTable32 ").append(" nentries= " + this.lut.length);
        return rep.append("]").toString();
    }

    public LookUpTableFPInterp(ICCCurveType curve, int dwNumInput) {
        super(curve, dwNumInput);
        double dfRatio = (double)(curve.nEntries - 1) / (double)(dwNumInput - 1);
        for (int i = 0; i < dwNumInput; ++i) {
            double dfHighIndex;
            int dwHighIndex;
            double dfTargetIndex = (double)i * dfRatio;
            double dfLowIndex = Math.floor(dfTargetIndex);
            int dwLowIndex = (int)dfLowIndex;
            if (dwLowIndex == (dwHighIndex = (int)(dfHighIndex = Math.ceil(dfTargetIndex)))) {
                this.lut[i] = (float)ICCCurveType.CurveToDouble(curve.entry(dwLowIndex));
                continue;
            }
            double dfLow = ICCCurveType.CurveToDouble(curve.entry(dwLowIndex));
            double dfHigh = ICCCurveType.CurveToDouble(curve.entry(dwHighIndex));
            this.lut[i] = (float)(dfLow + (dfHigh - dfLow) * (dfTargetIndex - dfLowIndex));
        }
    }
}

