/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.livelink;

import com.opentext.api.LAPI_USERS;
import com.opentext.api.LLBadServerCertificateException;
import com.opentext.api.LLConnect;
import com.opentext.api.LLCouldNotConnectHTTPException;
import com.opentext.api.LLHTTPAccessDeniedException;
import com.opentext.api.LLHTTPCGINotFoundException;
import com.opentext.api.LLHTTPClientException;
import com.opentext.api.LLHTTPForbiddenException;
import com.opentext.api.LLHTTPProxyAuthRequiredException;
import com.opentext.api.LLHTTPRedirectionException;
import com.opentext.api.LLHTTPServerException;
import com.opentext.api.LLIOException;
import com.opentext.api.LLIllegalOperationException;
import com.opentext.api.LLIndexOutOfBoundsException;
import com.opentext.api.LLNoFieldSpecifiedException;
import com.opentext.api.LLNoValueSpecifiedException;
import com.opentext.api.LLSSLNotAvailableException;
import com.opentext.api.LLSecurityProviderException;
import com.opentext.api.LLUnknownFieldException;
import com.opentext.api.LLUnsupportedAuthMethodException;
import com.opentext.api.LLValue;
import com.opentext.api.LLWebAuthInitException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.livelink.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.livelink.LLSERVER;
import org.apache.manifoldcf.ui.util.Encoder;

public class LivelinkAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: LivelinkAuthority.java 988245 2010-08-23 18:39:35Z kwright $";
    private static final String EDIT_CONFIGURATION_JS = "editConfiguration.js";
    private static final String EDIT_CONFIGURATION_SERVER_HTML = "editConfiguration_Server.html";
    private static final String EDIT_CONFIGURATION_CACHE_HTML = "editConfiguration_Cache.html";
    private static final String VIEW_CONFIGURATION_HTML = "viewConfiguration.html";
    private boolean hasSessionParameters = false;
    private boolean hasConnected = false;
    private long expirationTime = -1L;
    private static final long expirationInterval = 300000L;
    private String serverProtocol = null;
    private String serverName = null;
    private int serverPort = -1;
    private String serverUsername = null;
    private String serverPassword = null;
    private String serverHTTPCgi = null;
    private String serverHTTPNTLMDomain = null;
    private String serverHTTPNTLMUsername = null;
    private String serverHTTPNTLMPassword = null;
    private IKeystoreManager serverHTTPSKeystore = null;
    private LAPI_USERS LLUsers = null;
    private LLSERVER llServer = null;
    private String cacheLifetime = null;
    private String cacheLRUsize = null;
    private long responseLifetime = 60000L;
    private int LRUsize = 1000;
    private static final int FAILURE_RETRY_COUNT = 5;
    protected ICacheManager cacheManager = null;
    protected static StringSet emptyStringSet = new StringSet();

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.cacheManager = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
    }

    protected void getSessionParameters() throws ManifoldCFException {
        if (!this.hasSessionParameters) {
            String serverHTTPSKeystoreData;
            this.serverProtocol = this.params.getParameter("Server protocol");
            this.serverName = this.params.getParameter("Server name");
            String serverPortString = this.params.getParameter("Server port");
            this.serverUsername = this.params.getParameter("Server user name");
            this.serverPassword = this.params.getObfuscatedParameter("Server password");
            this.serverHTTPCgi = this.params.getParameter("Server HTTP CGI path");
            this.serverHTTPNTLMDomain = this.params.getParameter("Server HTTP NTLM domain");
            this.serverHTTPNTLMUsername = this.params.getParameter("Server HTTP NTLM user name");
            this.serverHTTPNTLMPassword = this.params.getObfuscatedParameter("Server HTTP NTLM password");
            if (this.serverProtocol == null || this.serverProtocol.length() == 0) {
                this.serverProtocol = "internal";
            }
            this.serverPort = serverPortString == null ? 2099 : new Integer(serverPortString);
            if (this.serverHTTPNTLMDomain != null && this.serverHTTPNTLMDomain.length() == 0) {
                this.serverHTTPNTLMDomain = null;
            }
            if (this.serverHTTPNTLMUsername == null || this.serverHTTPNTLMUsername.length() == 0) {
                this.serverHTTPNTLMUsername = null;
                this.serverHTTPNTLMPassword = null;
            }
            if ((serverHTTPSKeystoreData = this.params.getParameter("Server HTTPS truststore")) != null) {
                this.serverHTTPSKeystore = KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreData);
            }
            this.cacheLifetime = this.params.getParameter("Cache lifetime minutes");
            if (this.cacheLifetime == null) {
                this.cacheLifetime = "1";
            }
            this.cacheLRUsize = this.params.getParameter("Max cache LRU size");
            if (this.cacheLRUsize == null) {
                this.cacheLRUsize = "1000";
            }
            try {
                this.responseLifetime = Long.parseLong(this.cacheLifetime) * 60L * 1000L;
                this.LRUsize = Integer.parseInt(this.cacheLRUsize);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Cache lifetime or Cache LRU size must be an integer: " + e.getMessage(), (Throwable)e);
            }
            if (org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.isDebugEnabled()) {
                String passwordExists = this.serverPassword != null && this.serverPassword.length() > 0 ? "password exists" : "";
                org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.debug((Object)("Livelink: Livelink connection parameters: Server='" + this.serverName + "'; port='" + this.serverPort + "'; user name='" + this.serverUsername + "'; " + passwordExists));
            }
            this.hasSessionParameters = true;
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        this.getSessionParameters();
        if (!this.hasConnected) {
            int sanityRetryCount = 5;
            while (true) {
                try {
                    this.llServer = new LLSERVER(!this.serverProtocol.equals("internal"), this.serverProtocol.equals("https"), this.serverName, this.serverPort, this.serverUsername, this.serverPassword, this.serverHTTPCgi, this.serverHTTPNTLMDomain, this.serverHTTPNTLMUsername, this.serverHTTPNTLMPassword, this.serverHTTPSKeystore);
                    this.LLUsers = new LAPI_USERS((LLConnect)this.llServer.getLLSession());
                    if (org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.isDebugEnabled()) {
                        org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.debug((Object)"Livelink: Livelink session created.");
                    }
                    this.hasConnected = true;
                }
                catch (RuntimeException e) {
                    sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount);
                    continue;
                }
                break;
            }
        }
        this.expirationTime = System.currentTimeMillis() + 300000L;
    }

    public String check() throws ManifoldCFException {
        try {
            this.hasConnected = false;
            this.getSession();
            int sanityRetryCount = 5;
            while (true) {
                try {
                    LLValue userObject = new LLValue();
                    int status = this.LLUsers.GetUserInfo("Admin", userObject);
                    if (status == 103101 || status == 401203) {
                        return super.check();
                    }
                    if (status != 0) {
                        return "Connection failed: User authentication failed";
                    }
                    return super.check();
                }
                catch (RuntimeException e) {
                    sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount);
                    continue;
                }
                break;
            }
        }
        catch (ServiceInterruption e) {
            return "Temporary service interruption: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    public void poll() throws ManifoldCFException {
        if (!this.hasConnected) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.expirationTime) {
            this.hasConnected = false;
            this.expirationTime = -1L;
            if (this.llServer != null) {
                this.llServer.disconnect();
                this.llServer = null;
            }
            this.LLUsers = null;
        }
    }

    public boolean isConnected() {
        return this.hasConnected;
    }

    public void disconnect() throws ManifoldCFException {
        this.hasSessionParameters = false;
        this.hasConnected = false;
        this.expirationTime = -1L;
        if (this.llServer != null) {
            this.llServer.disconnect();
            this.llServer = null;
        }
        this.LLUsers = null;
        this.serverProtocol = null;
        this.serverName = null;
        this.serverPort = -1;
        this.serverUsername = null;
        this.serverPassword = null;
        this.serverHTTPCgi = null;
        this.serverHTTPNTLMDomain = null;
        this.serverHTTPNTLMUsername = null;
        this.serverHTTPNTLMPassword = null;
        this.serverHTTPSKeystore = null;
        this.cacheLifetime = null;
        this.cacheLRUsize = null;
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        this.getSessionParameters();
        AuthorizationResponseDescription objectDescription = new AuthorizationResponseDescription(userName, this.serverProtocol, this.serverName, this.serverPort, this.serverUsername, this.serverPassword, this.serverHTTPCgi, this.serverHTTPNTLMDomain, this.serverHTTPNTLMUsername, this.serverHTTPNTLMPassword, this.serverHTTPSKeystore, this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block8: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block8;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        try {
            this.getSession();
            if (org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.isDebugEnabled()) {
                org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.debug((Object)("Authentication user name = '" + userName + "'"));
            }
            String domainAndUser = userName;
            if (org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.isDebugEnabled()) {
                org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.debug((Object)("Livelink: Livelink user name = '" + domainAndUser + "'"));
            }
            int sanityRetryCount = 5;
            while (true) {
                try {
                    int j;
                    LLValue childrenObjects;
                    ArrayList<String> list = new ArrayList<String>();
                    LLValue userObject = new LLValue();
                    int status = this.LLUsers.GetUserInfo(domainAndUser, userObject);
                    if (status == 103101 || status == 401203) {
                        if (org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.isDebugEnabled()) {
                            org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.debug((Object)("Livelink: Livelink user '" + domainAndUser + "' does not exist"));
                        }
                        return RESPONSE_USERNOTFOUND;
                    }
                    if (status != 0) {
                        org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.warn((Object)("Livelink: User '" + domainAndUser + "' GetUserInfo error # " + Integer.toString(status) + " " + this.llServer.getErrors()));
                        return RESPONSE_UNREACHABLE;
                    }
                    int deleted = userObject.toInteger("Deleted");
                    if (deleted == 1) {
                        if (org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.isDebugEnabled()) {
                            org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.debug((Object)("Livelink: Livelink user '" + domainAndUser + "' has been deleted"));
                        }
                        return RESPONSE_USERNOTFOUND;
                    }
                    int privs = userObject.toInteger("UserPrivileges");
                    if ((privs & 0x800) == 2048) {
                        list.add("GUEST");
                    }
                    if ((privs & 0x100) == 256) {
                        list.add("SYSTEM");
                    }
                    if ((status = this.LLUsers.ListRights(0, domainAndUser, childrenObjects = new LLValue())) == 103101 || status == 401203) {
                        if (org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.isDebugEnabled()) {
                            org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.debug((Object)("Livelink: Livelink error looking up user rights for '" + domainAndUser + "' - user does not exist"));
                        }
                        return RESPONSE_USERNOTFOUND;
                    }
                    if (status != 0) {
                        org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.warn((Object)("Livelink: For user '" + domainAndUser + "', ListRights error # " + Integer.toString(status) + " " + this.llServer.getErrors()));
                        return RESPONSE_UNREACHABLE;
                    }
                    int size = childrenObjects.isRecord() ? 1 : (childrenObjects.isTable() ? childrenObjects.size() : 0);
                    for (j = 0; j < size; ++j) {
                        int token = childrenObjects.toInteger(j, "ID");
                        list.add(Integer.toString(token));
                    }
                    String[] rval = new String[list.size()];
                    for (j = 0; j < rval.length; ++j) {
                        rval[j] = (String)list.get(j);
                    }
                    return new AuthorizationResponse(rval, 0);
                }
                catch (RuntimeException e) {
                    sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount);
                    continue;
                }
                break;
            }
        }
        catch (ServiceInterruption e) {
            org.apache.manifoldcf.authorities.system.Logging.authorityConnectors.warn((Object)("Livelink: Server seems to be down: " + e.getMessage()), (Throwable)e);
            return RESPONSE_UNREACHABLE;
        }
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.Server"));
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.Cache"));
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_JS, null, true);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TabName", tabName);
        LivelinkAuthority.fillInServerTab(velocityContext, out, parameters);
        this.fillInCacheTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_SERVER_HTML, velocityContext);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_CACHE_HTML, velocityContext);
    }

    protected static void fillInServerTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        String serverHTTPNTLMPassword;
        String serverHTTPNTLMUserName;
        String serverHTTPNTLMDomain;
        String serverPassword;
        String serverUserName;
        String serverPort;
        String serverName;
        String serverProtocol = parameters.getParameter("Server protocol");
        if (serverProtocol == null) {
            serverProtocol = "internal";
        }
        if ((serverName = parameters.getParameter("Server name")) == null) {
            serverName = "localhost";
        }
        if ((serverPort = parameters.getParameter("Server port")) == null) {
            serverPort = "2099";
        }
        if ((serverUserName = parameters.getParameter("Server user name")) == null) {
            serverUserName = "";
        }
        serverPassword = (serverPassword = parameters.getObfuscatedParameter("Server password")) == null ? "" : out.mapPasswordToKey(serverPassword);
        String serverHTTPCgiPath = parameters.getParameter("Server HTTP CGI path");
        if (serverHTTPCgiPath == null) {
            serverHTTPCgiPath = "/livelink/livelink.exe";
        }
        if ((serverHTTPNTLMDomain = parameters.getParameter("Server HTTP NTLM domain")) == null) {
            serverHTTPNTLMDomain = "";
        }
        if ((serverHTTPNTLMUserName = parameters.getParameter("Server HTTP NTLM user name")) == null) {
            serverHTTPNTLMUserName = "";
        }
        serverHTTPNTLMPassword = (serverHTTPNTLMPassword = parameters.getObfuscatedParameter("Server HTTP NTLM password")) == null ? "" : out.mapPasswordToKey(serverHTTPNTLMPassword);
        String serverHTTPSKeystore = parameters.getParameter("Server HTTPS truststore");
        HashMap<String, String> serverCertificatesMap = null;
        String message = null;
        try {
            IKeystoreManager localServerHTTPSKeystore = serverHTTPSKeystore == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystore);
            String[] contents = localServerHTTPSKeystore.getContents();
            if (contents.length > 0) {
                serverCertificatesMap = new HashMap<String, String>();
                for (int i = 0; i < contents.length; ++i) {
                    String alias = contents[i];
                    Object description = localServerHTTPSKeystore.getDescription(alias);
                    if (((String)description).length() > 128) {
                        description = ((String)description).substring(0, 125) + "...";
                    }
                    serverCertificatesMap.put(alias, (String)description);
                }
            }
        }
        catch (ManifoldCFException e) {
            message = e.getMessage();
            Logging.connectors.warn((Object)e);
        }
        velocityContext.put("SERVERPROTOCOL", serverProtocol);
        velocityContext.put("SERVERNAME", serverName);
        velocityContext.put("SERVERPORT", serverPort);
        velocityContext.put("SERVERUSERNAME", serverUserName);
        velocityContext.put("SERVERPASSWORD", serverPassword);
        velocityContext.put("SERVERHTTPCGIPATH", serverHTTPCgiPath);
        velocityContext.put("SERVERHTTPNTLMDOMAIN", serverHTTPNTLMDomain);
        velocityContext.put("SERVERHTTPNTLMUSERNAME", serverHTTPNTLMUserName);
        velocityContext.put("SERVERHTTPNTLMPASSWORD", serverHTTPNTLMPassword);
        if (serverHTTPSKeystore != null) {
            velocityContext.put("SERVERHTTPSKEYSTORE", serverHTTPSKeystore);
        }
        if (serverCertificatesMap != null) {
            velocityContext.put("SERVERCERTIFICATESMAP", serverCertificatesMap);
        }
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
    }

    private void fillInCacheTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        String cacheLRUsize;
        String cacheLifetime = parameters.getParameter("Cache lifetime minutes");
        if (cacheLifetime == null) {
            cacheLifetime = "1";
        }
        if ((cacheLRUsize = parameters.getParameter("Max cache LRU size")) == null) {
            cacheLRUsize = "1000";
        }
        velocityContext.put("CACHELIFETIME", cacheLifetime);
        velocityContext.put("CACHELRUSIZE", cacheLRUsize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String cacheLRUsize;
        String serverHTTPNTLMPassword;
        String serverHTTPNTLMUserName;
        String serverHTTPNTLMDomain;
        String serverHTTPCgiPath;
        String serverPassword;
        String serverUserName;
        String serverPort;
        String serverName;
        String serverProtocol = variableContext.getParameter("serverprotocol");
        if (serverProtocol != null) {
            parameters.setParameter("Server protocol", serverProtocol);
        }
        if ((serverName = variableContext.getParameter("servername")) != null) {
            parameters.setParameter("Server name", serverName);
        }
        if ((serverPort = variableContext.getParameter("serverport")) != null) {
            parameters.setParameter("Server port", serverPort);
        }
        if ((serverUserName = variableContext.getParameter("serverusername")) != null) {
            parameters.setParameter("Server user name", serverUserName);
        }
        if ((serverPassword = variableContext.getParameter("serverpassword")) != null) {
            parameters.setObfuscatedParameter("Server password", variableContext.mapKeyToPassword(serverPassword));
        }
        if ((serverHTTPCgiPath = variableContext.getParameter("serverhttpcgipath")) != null) {
            parameters.setParameter("Server HTTP CGI path", serverHTTPCgiPath);
        }
        if ((serverHTTPNTLMDomain = variableContext.getParameter("serverhttpntlmdomain")) != null) {
            parameters.setParameter("Server HTTP NTLM domain", serverHTTPNTLMDomain);
        }
        if ((serverHTTPNTLMUserName = variableContext.getParameter("serverhttpntlmusername")) != null) {
            parameters.setParameter("Server HTTP NTLM user name", serverHTTPNTLMUserName);
        }
        if ((serverHTTPNTLMPassword = variableContext.getParameter("serverhttpntlmpassword")) != null) {
            parameters.setObfuscatedParameter("Server HTTP NTLM password", variableContext.mapKeyToPassword(serverHTTPNTLMPassword));
        }
        String serverHTTPSKeystoreValue = variableContext.getParameter("serverhttpskeystoredata");
        String serverConfigOp = variableContext.getParameter("serverconfigop");
        if (serverConfigOp != null) {
            String alias;
            if (serverConfigOp.equals("Delete")) {
                alias = variableContext.getParameter("serverkeystorealias");
                IKeystoreManager mgr = serverHTTPSKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                serverHTTPSKeystoreValue = mgr.getString();
            } else if (serverConfigOp.equals("Add")) {
                alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("servercertificate");
                IKeystoreManager mgr = serverHTTPSKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                serverHTTPSKeystoreValue = mgr.getString();
            }
        }
        parameters.setParameter("Server HTTPS truststore", serverHTTPSKeystoreValue);
        String cacheLifetime = variableContext.getParameter("cachelifetime");
        if (cacheLifetime != null) {
            parameters.setParameter("Cache lifetime minutes", cacheLifetime);
        }
        if ((cacheLRUsize = variableContext.getParameter("cachelrusize")) != null) {
            parameters.setParameter("Max cache LRU size", cacheLRUsize);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                configMap.put(Encoder.bodyEscape((String)param), "********");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore") || param.length() > "truststore".length() && param.substring(param.length() - "truststore".length()).equalsIgnoreCase("truststore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                configMap.put(Encoder.bodyEscape((String)param), "=&lt;" + Integer.toString(kmanager.getContents().length) + Messages.getBodyString(locale, "LivelinkConnector.certificates") + "&gt;");
                continue;
            }
            configMap.put(Encoder.bodyEscape((String)param), Encoder.bodyEscape((String)value));
        }
        paramMap.put("CONFIGMAP", configMap);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIGURATION_HTML, paramMap);
    }

    protected int handleLivelinkRuntimeException(RuntimeException e, int sanityRetryCount) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof LLHTTPAccessDeniedException || e instanceof LLHTTPClientException || e instanceof LLHTTPServerException || e instanceof LLIndexOutOfBoundsException || e instanceof LLNoFieldSpecifiedException || e instanceof LLNoValueSpecifiedException || e instanceof LLSecurityProviderException || e instanceof LLUnknownFieldException) {
            String details = this.llServer.getErrors();
            throw new ManifoldCFException("Livelink API error: " + e.getMessage() + (String)(details == null ? "" : "; " + details), (Throwable)e, 5);
        }
        if (e instanceof LLBadServerCertificateException || e instanceof LLHTTPCGINotFoundException || e instanceof LLCouldNotConnectHTTPException || e instanceof LLHTTPForbiddenException || e instanceof LLHTTPProxyAuthRequiredException || e instanceof LLHTTPRedirectionException || e instanceof LLUnsupportedAuthMethodException || e instanceof LLWebAuthInitException) {
            String details = this.llServer.getErrors();
            throw new ManifoldCFException("Livelink API error: " + e.getMessage() + (String)(details == null ? "" : "; " + details), (Throwable)e);
        }
        if (e instanceof LLSSLNotAvailableException) {
            String details = this.llServer.getErrors();
            throw new ManifoldCFException("Missing llssl.jar error: " + e.getMessage() + (String)(details == null ? "" : "; " + details), (Throwable)e);
        }
        if (e instanceof LLIllegalOperationException) {
            String details = this.llServer.getErrors();
            return LivelinkAuthority.assessRetry(sanityRetryCount, new ManifoldCFException("Livelink API illegal operation error: " + e.getMessage() + (String)(details == null ? "" : "; " + details), (Throwable)e));
        }
        if (e instanceof LLIOException || e instanceof RuntimeException && e.getClass().getName().startsWith("com.opentext.api.")) {
            try {
                InetAddress.getByName(this.serverName);
            }
            catch (UnknownHostException e2) {
                throw new ManifoldCFException("Server name '" + this.serverName + "' cannot be resolved", (Throwable)e2);
            }
            throw new ServiceInterruption("Transient error: " + e.getMessage(), (Throwable)e, System.currentTimeMillis() + 300000L, System.currentTimeMillis() + 43200000L, -1, true);
        }
        throw e;
    }

    protected static int assessRetry(int sanityRetryCount, ManifoldCFException e) throws ManifoldCFException {
        if (sanityRetryCount == 0) {
            throw e;
        }
        --sanityRetryCount;
        try {
            ManifoldCF.sleep((long)1000L);
        }
        catch (InterruptedException e2) {
            throw new ManifoldCFException(e2.getMessage(), (Throwable)e2, 2);
        }
        return sanityRetryCount;
    }

    protected static class AuthorizationResponseDescription
    extends BaseDescription {
        protected final String userName;
        protected final String serverProtocol;
        protected final String serverName;
        protected final int serverPort;
        protected final String serverUsername;
        protected final String serverPassword;
        protected final String serverHTTPCgi;
        protected final String serverHTTPNTLMDomain;
        protected final String serverHTTPNTLMUsername;
        protected final String serverHTTPNTLMPassword;
        protected final String serverHTTPSKeystore;
        protected long responseLifetime;
        protected long expirationTime = -1L;

        public AuthorizationResponseDescription(String userName, String serverProtocol, String serverName, int serverPort, String serverUsername, String serverPassword, String serverHTTPCgi, String serverHTTPNTLMDomain, String serverHTTPNTLMUsername, String serverHTTPNTLMPassword, IKeystoreManager serverHTTPSKeystore, long responseLifetime, int LRUsize) throws ManifoldCFException {
            super("LiveLinkAuthority", LRUsize);
            this.userName = userName;
            this.serverProtocol = serverProtocol;
            this.serverName = serverName;
            this.serverPort = serverPort;
            this.serverUsername = serverUsername;
            this.serverPassword = serverPassword;
            this.serverHTTPCgi = serverHTTPCgi == null ? "" : serverHTTPCgi;
            this.serverHTTPNTLMDomain = serverHTTPNTLMDomain == null ? "" : serverHTTPNTLMDomain;
            this.serverHTTPNTLMUsername = serverHTTPNTLMUsername == null ? "" : serverHTTPNTLMUsername;
            this.serverHTTPNTLMPassword = serverHTTPNTLMPassword == null ? "" : serverHTTPNTLMPassword;
            this.serverHTTPSKeystore = serverHTTPSKeystore != null ? serverHTTPSKeystore.getString() : null;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            return ((Object)((Object)this)).getClass().getName() + "-" + this.userName + "-" + this.serverProtocol + "-" + this.serverName + "-" + Integer.toString(this.serverPort) + "-" + this.serverUsername + "-" + this.serverPassword + "-" + this.serverHTTPCgi + "-" + this.serverHTTPNTLMDomain + "-" + this.serverHTTPNTLMUsername + "-" + this.serverHTTPNTLMPassword + "-" + (this.serverHTTPSKeystore == null ? "" : this.serverHTTPSKeystore);
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.serverProtocol.hashCode() + this.serverName.hashCode() + new Integer(this.serverPort).hashCode() + this.serverUsername.hashCode() + this.serverPassword.hashCode() + this.serverHTTPCgi.hashCode() + this.serverHTTPNTLMDomain.hashCode() + this.serverHTTPNTLMUsername.hashCode() + this.serverHTTPNTLMPassword.hashCode() + (this.serverHTTPSKeystore == null ? 0 : this.serverHTTPSKeystore.hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorizationResponseDescription)) {
                return false;
            }
            AuthorizationResponseDescription ard = (AuthorizationResponseDescription)((Object)o);
            return ard.userName.equals(this.userName) && ard.serverProtocol.equals(this.serverProtocol) && ard.serverName.equals(this.serverName) && ard.serverPort == this.serverPort && ard.serverUsername.equals(this.serverUsername) && ard.serverPassword.equals(this.serverPassword) && ard.serverHTTPCgi.equals(this.serverHTTPCgi) && ard.serverHTTPNTLMDomain.equals(this.serverHTTPNTLMDomain) && ard.serverHTTPNTLMUsername.equals(this.serverHTTPNTLMUsername) && ard.serverHTTPNTLMPassword.equals(this.serverHTTPNTLMPassword) && (ard.serverHTTPSKeystore != null && this.serverHTTPSKeystore != null && ard.serverHTTPSKeystore.equals(this.serverHTTPSKeystore) || (ard.serverHTTPSKeystore == null || this.serverHTTPSKeystore == null) && ard.serverHTTPSKeystore == this.serverHTTPSKeystore);
        }
    }
}

