/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSConstants;

public class WSSecurityException
extends RemoteException {
    public static final int FAILURE = 0;
    public static final int UNSUPPORTED_SECURITY_TOKEN = 1;
    public static final int UNSUPPORTED_ALGORITHM = 2;
    public static final int INVALID_SECURITY = 3;
    public static final int INVALID_SECURITY_TOKEN = 4;
    public static final int FAILED_AUTHENTICATION = 5;
    public static final int FAILED_CHECK = 6;
    public static final int SECURITY_TOKEN_UNAVAILABLE = 7;
    public static final int MESSAGE_EXPIRED = 8;
    public static final int FAILED_ENCRYPTION = 9;
    public static final int FAILED_SIGNATURE = 10;
    private static ResourceBundle resources;
    private static final Map FAULT_CODE_MAP;
    private int errorCode;
    private Throwable cause;

    public WSSecurityException(int errorCode, String msgId, Object[] args, Throwable exception) {
        super(WSSecurityException.getMessage(errorCode, msgId, args));
        this.cause = exception;
        this.errorCode = errorCode;
    }

    public WSSecurityException(int errorCode, String msgId, Object[] args) {
        super(WSSecurityException.getMessage(errorCode, msgId, args));
        this.errorCode = errorCode;
    }

    public WSSecurityException(int errorCode, String msgId) {
        this(errorCode, msgId, null);
    }

    public WSSecurityException(int errorCode) {
        this(errorCode, null, null);
    }

    public WSSecurityException(String errorMessage) {
        super(errorMessage);
    }

    public WSSecurityException(String errorMessage, Throwable t) {
        super(errorMessage);
        this.cause = t;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public QName getFaultCode() {
        Object ret = FAULT_CODE_MAP.get(new Integer(this.errorCode));
        if (ret != null) {
            return (QName)ret;
        }
        return null;
    }

    public Throwable getCause() {
        return this.cause != null ? this.cause : super.getCause();
    }

    public String getMessage(boolean verbose) {
        if (verbose) {
            return super.getMessage() + "; nested exception is: \n\t" + this.cause.toString();
        }
        return super.getMessage();
    }

    private static String getMessage(int errorCode, String msgId, Object[] args) {
        String msg = null;
        try {
            msg = resources.getString(String.valueOf(errorCode));
            if (msgId != null) {
                msg = msg + " (" + MessageFormat.format(resources.getString(msgId), args) + ")";
                return msg;
            }
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("Undefined '" + msgId + "' resource property", e);
        }
        return msg;
    }

    static {
        FAULT_CODE_MAP = new HashMap();
        try {
            resources = ResourceBundle.getBundle("org.apache.ws.security.errors");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        FAULT_CODE_MAP.put(new Integer(1), WSConstants.UNSUPPORTED_SECURITY_TOKEN);
        FAULT_CODE_MAP.put(new Integer(2), WSConstants.UNSUPPORTED_ALGORITHM);
        FAULT_CODE_MAP.put(new Integer(3), WSConstants.INVALID_SECURITY);
        FAULT_CODE_MAP.put(new Integer(4), WSConstants.INVALID_SECURITY_TOKEN);
        FAULT_CODE_MAP.put(new Integer(5), WSConstants.FAILED_AUTHENTICATION);
        FAULT_CODE_MAP.put(new Integer(6), WSConstants.FAILED_CHECK);
        FAULT_CODE_MAP.put(new Integer(7), WSConstants.SECURITY_TOKEN_UNAVAILABLE);
        FAULT_CODE_MAP.put(new Integer(8), WSConstants.MESSAGE_EXPIRED);
    }
}

