/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeProviderPair;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

final class DataStoreRegistry {
    private final ServiceLoader<DataStoreProvider> loader;

    public DataStoreRegistry() {
        this.loader = DefaultFactories.createServiceLoader(DataStoreProvider.class);
    }

    public DataStoreRegistry(ClassLoader classLoader) {
        ArgumentChecks.ensureNonNull("loader", classLoader);
        this.loader = ServiceLoader.load(DataStoreProvider.class, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataStoreProvider> providers() {
        ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            final Iterator<DataStoreProvider> iterator = this.loader.iterator();
            return new LazySet((Iterator)new Iterator<DataStoreProvider>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    ServiceLoader serviceLoader = DataStoreRegistry.this.loader;
                    synchronized (serviceLoader) {
                        return iterator.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public DataStoreProvider next() {
                    ServiceLoader serviceLoader = DataStoreRegistry.this.loader;
                    synchronized (serviceLoader) {
                        return (DataStoreProvider)iterator.next();
                    }
                }
            });
        }
    }

    public String probeContentType(Object object) throws DataStoreException {
        ArgumentChecks.ensureNonNull("storage", object);
        ProbeProviderPair probeProviderPair = this.lookup(object, false);
        return probeProviderPair != null ? probeProviderPair.probe.getMimeType() : null;
    }

    public DataStore open(Object object) throws UnsupportedStorageException, DataStoreException {
        ArgumentChecks.ensureNonNull("storage", object);
        return this.lookup((Object)object, (boolean)true).store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProbeProviderPair lookup(Object object, boolean bl) throws DataStoreException {
        StorageConnector storageConnector = object instanceof StorageConnector ? (StorageConnector)object : new StorageConnector(object);
        String string = storageConnector.getFileExtension();
        boolean bl2 = string != null && !string.isEmpty();
        Category[] categoryArray = Category.values(bl2);
        Object object2 = null;
        LinkedList<ProbeProviderPair> linkedList = new LinkedList<ProbeProviderPair>();
        try {
            block9: for (int i = 0; i < categoryArray.length; ++i) {
                Object object3;
                DataStoreProvider dataStoreProvider;
                Iterator<DataStoreProvider> iterator;
                Category category = categoryArray[i];
                ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
                synchronized (serviceLoader) {
                    iterator = this.loader.iterator();
                    dataStoreProvider = iterator.hasNext() ? iterator.next() : null;
                }
                while (dataStoreProvider != null) {
                    Object object4;
                    boolean bl3;
                    object3 = dataStoreProvider.getClass().getAnnotation(StoreMetadata.class);
                    if (object3 == null) {
                        bl3 = i == 0;
                    } else {
                        boolean bl4 = bl3 = object3.yieldPriority() == category.yieldPriority;
                        if (bl3 & bl2) {
                            boolean bl5 = bl3 = ArraysExt.containsIgnoreCase(object3.fileSuffixes(), string) == category.useSuffix;
                        }
                    }
                    if (bl3) {
                        object4 = dataStoreProvider.probeContent(storageConnector);
                        if (((ProbeResult)object4).isSupported()) {
                            object2 = new ProbeProviderPair(dataStoreProvider, (ProbeResult)object4);
                            break block9;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(object4)) {
                            linkedList.add(new ProbeProviderPair(dataStoreProvider, (ProbeResult)object4));
                        } else if (ProbeResult.UNDETERMINED.equals(object4) && object2 == null) {
                            object2 = new ProbeProviderPair(dataStoreProvider, (ProbeResult)object4);
                        }
                    }
                    object4 = this.loader;
                    synchronized (object4) {
                        dataStoreProvider = iterator.hasNext() ? iterator.next() : null;
                    }
                }
                while (!linkedList.isEmpty() && storageConnector.prefetch()) {
                    Iterator iterator2 = linkedList.iterator();
                    while (iterator2.hasNext()) {
                        object3 = (ProbeProviderPair)iterator2.next();
                        ((ProbeProviderPair)object3).probe = ((ProbeProviderPair)object3).provider.probeContent(storageConnector);
                        if (((ProbeProviderPair)object3).probe.isSupported()) {
                            object2 = object3;
                            break block9;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(((ProbeProviderPair)object3).probe)) continue;
                        if (object2 == null && ProbeResult.UNDETERMINED.equals(((ProbeProviderPair)object3).probe)) {
                            object2 = object3;
                        }
                        iterator2.remove();
                    }
                }
            }
            if (bl && object2 != null) {
                ((ProbeProviderPair)object2).store = ((ProbeProviderPair)object2).provider.open(storageConnector);
                storageConnector = null;
            }
        }
        finally {
            if (storageConnector != null && storageConnector != object) {
                storageConnector.closeAllExcept(null);
            }
        }
        if (bl && object2 == null) {
            String string2 = storageConnector.getStorageName();
            throw new UnsupportedStorageException(null, 14, string2);
        }
        return object2;
    }

    private static enum Category {
        SUFFIX_MATCH(true, false),
        IGNORE_SUFFIX(false, false),
        DEFERRED(true, true),
        DEFERRED_IGNORE_SUFFIX(false, true);

        final boolean useSuffix;
        final boolean yieldPriority;

        private Category(boolean bl, boolean bl2) {
            this.useSuffix = bl;
            this.yieldPriority = bl2;
        }

        static Category[] values(boolean bl) {
            Category[] categoryArray;
            if (bl) {
                categoryArray = Category.values();
            } else {
                Category[] categoryArray2 = new Category[2];
                categoryArray2[0] = IGNORE_SUFFIX;
                categoryArray = categoryArray2;
                categoryArray2[1] = DEFERRED_IGNORE_SUFFIX;
            }
            return categoryArray;
        }
    }
}

