/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.solr;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;

public class PreemptiveBasicAuthInterceptor
implements HttpRequestInterceptor {
    private final AuthScope scope;

    public PreemptiveBasicAuthInterceptor(AuthScope scope) {
        this.scope = scope;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (!this.alreadyAppliesAuthScheme(context)) {
            CredentialsProvider provider = this.getCredentialsProvider(context);
            Credentials credentials = provider.getCredentials(this.scope);
            if (credentials == null) {
                throw new HttpException("Missing credentials for preemptive basic authentication.");
            }
            AuthState state = this.getAuthState(context);
            state.update((AuthScheme)new BasicScheme(), credentials);
        }
    }

    private boolean alreadyAppliesAuthScheme(HttpContext context) {
        AuthState authState = this.getAuthState(context);
        return authState.getAuthScheme() != null;
    }

    private AuthState getAuthState(HttpContext context) {
        return (AuthState)context.getAttribute("http.auth.target-scope");
    }

    private CredentialsProvider getCredentialsProvider(HttpContext context) {
        return (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
    }
}

