/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.Subject;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.chemistry.opencmis.client.bindings.spi.StandardAuthenticationProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LTPAWSSecurityAuthenticationProvider
extends StandardAuthenticationProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LTPAWSSecurityAuthenticationProvider.class);

    @Override
    public Element getSOAPHeaders(Object portObject) {
        String securityToken = this.getSecurityToken();
        if (securityToken == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("securityToken is null");
            }
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        long created = System.currentTimeMillis();
        long expires = created + 86400000L;
        try {
            Document document = XMLUtils.newDomDocument();
            Element wsseSecurityElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
            Element wsuTimestampElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
            wsseSecurityElement.appendChild(wsuTimestampElement);
            Element tsCreatedElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
            tsCreatedElement.appendChild(document.createTextNode(sdf.format(created)));
            wsuTimestampElement.appendChild(tsCreatedElement);
            Element tsExpiresElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
            tsExpiresElement.appendChild(document.createTextNode(sdf.format(expires)));
            wsuTimestampElement.appendChild(tsExpiresElement);
            Element wsseBinarySecurityTokenElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
            wsseBinarySecurityTokenElement.setAttribute("xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            wsseBinarySecurityTokenElement.setAttribute("xmlns:wsst", "http://www.ibm.com/websphere/appserver/tokentype");
            wsseBinarySecurityTokenElement.setAttribute("wsu:Id", "ltpa_20");
            wsseBinarySecurityTokenElement.setAttribute("ValueType", "wsst:LTPAv2");
            wsseBinarySecurityTokenElement.appendChild(document.createTextNode(securityToken));
            wsseSecurityElement.appendChild(wsseBinarySecurityTokenElement);
            return wsseSecurityElement;
        }
        catch (ParserConfigurationException e) {
            throw new CmisRuntimeException("Could not build SOAP header: " + e.getMessage(), (Throwable)e);
        }
    }

    private String getSecurityToken() {
        try {
            Class wsSubjectClass = ClassLoaderUtil.loadClass((String)"com.ibm.websphere.security.auth.WSSubject");
            Class wsCredentialClass = ClassLoaderUtil.loadClass((String)"com.ibm.websphere.security.cred.WSCredential");
            Method m = wsSubjectClass.getMethod("getRunAsSubject", new Class[0]);
            Subject securitySubject = (Subject)m.invoke(null, new Object[0]);
            if (securitySubject != null) {
                Set securityCredentials = securitySubject.getPublicCredentials(wsCredentialClass);
                Object securityCredential = securityCredentials.iterator().next();
                String user = (String)this.invokeSecurityCredentialMethod(wsCredentialClass, securityCredential, "getSecurityName");
                if (user.equalsIgnoreCase("UNAUTHENTICATED")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("User = UNAUTHENTICATED");
                    }
                    return null;
                }
                byte[] token = (byte[])this.invokeSecurityCredentialMethod(wsCredentialClass, securityCredential, "getCredentialToken");
                if (token == null) {
                    return null;
                }
                return Base64.encodeBytes((byte[])token);
            }
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Could not build SOAP header: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private <T> T invokeSecurityCredentialMethod(Class<?> credentialClass, Object securityCredential, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = credentialClass.getMethod(methodName, new Class[0]);
        return (T)m.invoke(securityCredential, new Object[0]);
    }

    @Override
    protected boolean getSendBasicAuth() {
        return false;
    }

    @Override
    protected boolean getSendUsernameToken() {
        return false;
    }
}

