/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.manifoldcf.core.database.Database;
import org.apache.manifoldcf.core.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ResultSpecification;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.system.Logging;

public class DBInterfaceMySQL
extends Database
implements IDBInterface {
    public static final String _rcsid = "@(#)$Id: DBInterfaceMySQL.java 999670 2010-09-21 22:18:19Z kwright $";
    public static final String mysqlServerProperty = "org.apache.manifoldcf.mysql.server";
    public static final String mysqlClientProperty = "org.apache.manifoldcf.mysql.client";
    public static final String mysqlSslProperty = "org.apache.manifoldcf.mysql.ssl";
    private static final String _driver = "com.mysql.jdbc.Driver";
    protected ILockManager lockManager;
    protected int serializableDepth = 0;
    protected List<String> tablesToAnalyze = new ArrayList<String>();
    protected static Map<String, TableStatistics> currentAnalyzeStatistics = new HashMap<String, TableStatistics>();
    protected static Map<String, Integer> analyzeThresholds = new HashMap<String, Integer>();
    protected static final int commitThreshold = 100;
    protected static final String statslockAnalyzePrefix = "statslock-analyze-";
    protected static final String statsAnalyzePrefix = "stats-analyze-";
    protected String cacheKey = CacheKeyFactory.makeDatabaseKey(this.databaseName);

    public DBInterfaceMySQL(IThreadContext tc, String databaseName, String userName, String password) throws ManifoldCFException {
        this(tc, _driver, databaseName, userName, password);
    }

    protected DBInterfaceMySQL(IThreadContext tc, String jdbcDriverClass, String databaseName, String userName, String password) throws ManifoldCFException {
        super(tc, DBInterfaceMySQL.getJdbcUrl(tc, databaseName), jdbcDriverClass, databaseName, userName, password);
        this.lockManager = LockManagerFactory.make(tc);
    }

    private static String getJdbcUrl(IThreadContext tc, String theDatabaseName) throws ManifoldCFException {
        String server = LockManagerFactory.getProperty(tc, mysqlServerProperty);
        String ssl = LockManagerFactory.getProperty(tc, mysqlSslProperty);
        if (server == null || server.length() == 0) {
            server = "localhost";
        }
        String jdbcUrl = "jdbc:mysql://" + server + "/" + theDatabaseName + "?useUnicode=true&characterEncoding=utf8";
        if (Boolean.parseBoolean(ssl)) {
            jdbcUrl = jdbcUrl + "&useSSL=true&requireSSL=true";
        }
        return jdbcUrl;
    }

    protected String getJdbcDriverClass() {
        return _driver;
    }

    @Override
    protected void interruptCleanup(Connection connection) {
    }

    protected ManifoldCFException reinterpretException(ManifoldCFException theException) {
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Reinterpreting exception '" + theException.getMessage() + "'.  The exception type is " + Integer.toString(theException.getErrorCode())));
        }
        if (theException.getErrorCode() != 4) {
            return theException;
        }
        Throwable e = theException.getCause();
        if (!(e instanceof SQLException)) {
            return theException;
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is possibly a transaction abort signal"));
        }
        SQLException sqlException = (SQLException)e;
        String message = sqlException.getMessage();
        String sqlState = sqlException.getSQLState();
        if (sqlState != null && sqlState.equals("23000")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("40001")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("40P01")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("HY000")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("41000")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("23505")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is NOT a transaction abort signal"));
        }
        return theException;
    }

    @Override
    protected String mapLookupName(String rawColumnName, String rawLabelName) {
        return rawLabelName;
    }

    @Override
    public void openDatabase() throws ManifoldCFException {
    }

    @Override
    public void closeDatabase() throws ManifoldCFException {
    }

    @Override
    public String getDatabaseCacheKey() {
        return this.cacheKey;
    }

    @Override
    public void performInsert(String tableName, Map<String, Object> parameterMap, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuilder bf = new StringBuilder();
        bf.append("INSERT INTO ");
        bf.append(tableName);
        bf.append(" (");
        StringBuilder values = new StringBuilder(" VALUES (");
        Iterator<Map.Entry<String, Object>> it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String key = e.getKey();
            Object o = e.getValue();
            if (o == null) continue;
            paramArray.add(o);
            if (!first) {
                bf.append(',');
                values.append(',');
            }
            bf.append(key);
            values.append('?');
            first = false;
        }
        bf.append(')');
        values.append(')');
        bf.append((CharSequence)values);
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    @Override
    public void performUpdate(String tableName, Map<String, Object> parameterMap, String whereClause, List whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuilder bf = new StringBuilder();
        bf.append("UPDATE ");
        bf.append(tableName);
        bf.append(" SET ");
        Iterator<Map.Entry<String, Object>> it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String key = e.getKey();
            Object o = e.getValue();
            if (!first) {
                bf.append(',');
            }
            bf.append(key);
            bf.append('=');
            if (o == null) {
                bf.append("NULL");
            } else {
                bf.append('?');
                paramArray.add(o);
            }
            first = false;
        }
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
            if (whereParameters != null) {
                for (int i = 0; i < whereParameters.size(); ++i) {
                    Object value = whereParameters.get(i);
                    paramArray.add(value);
                }
            }
        }
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    @Override
    public void performDelete(String tableName, String whereClause, List whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuilder bf = new StringBuilder();
        bf.append("DELETE FROM ");
        bf.append(tableName);
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
        } else {
            whereParameters = null;
        }
        this.performModification(bf.toString(), whereParameters, invalidateKeys);
    }

    @Override
    public void performCreate(String tableName, Map<String, ColumnDescription> columnMap, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuilder queryBuffer = new StringBuilder("CREATE TABLE ");
        queryBuffer.append(tableName);
        queryBuffer.append('(');
        Iterator<String> iter = columnMap.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String columnName = iter.next();
            ColumnDescription cd = columnMap.get(columnName);
            if (!first) {
                queryBuffer.append(',');
            } else {
                first = false;
            }
            DBInterfaceMySQL.appendDescription(queryBuffer, columnName, cd, false, true);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, invalidateKeys);
    }

    protected static void appendDescription(StringBuilder queryBuffer, String columnName, ColumnDescription cd, boolean forceNull, boolean includeRestrict) {
        queryBuffer.append(columnName);
        queryBuffer.append(' ');
        queryBuffer.append(DBInterfaceMySQL.mapType(cd.getTypeString()));
        if (forceNull || cd.getIsNull()) {
            queryBuffer.append(" NULL");
        } else {
            queryBuffer.append(" NOT NULL");
        }
        if (cd.getIsPrimaryKey()) {
            queryBuffer.append(" PRIMARY KEY");
        }
        if (cd.getReferenceTable() != null && includeRestrict) {
            queryBuffer.append(" REFERENCES ");
            queryBuffer.append(cd.getReferenceTable());
            queryBuffer.append('(');
            queryBuffer.append(cd.getReferenceColumn());
            queryBuffer.append(") ON DELETE");
            if (cd.getReferenceCascade()) {
                queryBuffer.append(" CASCADE");
            } else {
                queryBuffer.append(" RESTRICT");
            }
        }
    }

    protected static String mapType(String inputType) {
        if (inputType.equalsIgnoreCase("float")) {
            return "DOUBLE";
        }
        if (inputType.equalsIgnoreCase("blob")) {
            return "LONGBLOB";
        }
        return inputType;
    }

    @Override
    public void performAlter(String tableName, Map<String, ColumnDescription> columnMap, Map<String, ColumnDescription> columnModifyMap, List<String> columnDeleteList, StringSet invalidateKeys) throws ManifoldCFException {
        this.beginTransaction(0);
        try {
            StringBuilder sb;
            ColumnDescription cd;
            if (columnDeleteList != null) {
                int i = 0;
                while (i < columnDeleteList.size()) {
                    String columnName = columnDeleteList.get(i++);
                    this.performModification("ALTER TABLE " + tableName + " DROP " + columnName, null, invalidateKeys);
                }
            }
            if (columnModifyMap != null) {
                for (String columnName : columnModifyMap.keySet()) {
                    cd = columnModifyMap.get(columnName);
                    sb = new StringBuilder();
                    DBInterfaceMySQL.appendDescription(sb, columnName, cd, false, false);
                    this.performModification("ALTER TABLE " + tableName + " CHANGE " + columnName + " " + sb.toString(), null, invalidateKeys);
                }
            }
            if (columnMap != null) {
                for (String columnName : columnMap.keySet()) {
                    cd = columnMap.get(columnName);
                    sb = new StringBuilder();
                    DBInterfaceMySQL.appendDescription(sb, columnName, cd, false, true);
                    this.performModification("ALTER TABLE " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                }
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void addTableIndex(String tableName, boolean unique, List<String> columnList) throws ManifoldCFException {
        String[] columns = new String[columnList.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = columnList.get(i);
        }
        this.performAddIndex(null, tableName, new IndexDescription(unique, columns));
    }

    @Override
    public void performAddIndex(String indexName, String tableName, IndexDescription description) throws ManifoldCFException {
        String[] columnNames = description.getColumnNames();
        if (columnNames.length == 0) {
            return;
        }
        if (indexName == null) {
            indexName = "I" + IDFactory.make(this.context);
        }
        StringBuilder queryBuffer = new StringBuilder("CREATE ");
        if (description.getIsUnique()) {
            queryBuffer.append("UNIQUE ");
        }
        queryBuffer.append("INDEX ");
        queryBuffer.append(indexName);
        queryBuffer.append(" ON ");
        queryBuffer.append(tableName);
        queryBuffer.append(" (");
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i];
            if (i > 0) {
                queryBuffer.append(',');
            }
            queryBuffer.append(colName);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, null);
    }

    @Override
    public void performRemoveIndex(String indexName, String tableName) throws ManifoldCFException {
        this.performModification("DROP INDEX " + indexName + " ON " + tableName, null, null);
    }

    protected int readDatum(String datumName) throws ManifoldCFException {
        byte[] bytes = this.lockManager.readData(datumName);
        if (bytes == null) {
            return 0;
        }
        return (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8) + ((bytes[2] & 0xFF) << 16) + ((bytes[3] & 0xFF) << 24);
    }

    protected void writeDatum(String datumName, int value) throws ManifoldCFException {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        this.lockManager.writeData(datumName, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeTable(String tableName) throws ManifoldCFException {
        String tableStatisticsLock = statslockAnalyzePrefix + tableName;
        this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
        try {
            TableStatistics ts = currentAnalyzeStatistics.get(tableName);
            this.lockManager.enterWriteLock(tableStatisticsLock);
            try {
                String eventDatum = statsAnalyzePrefix + tableName;
                this.analyzeTableInternal(tableName);
                this.writeDatum(eventDatum, 0);
                if (ts != null) {
                    ts.reset();
                }
            }
            finally {
                this.lockManager.leaveWriteLock(tableStatisticsLock);
            }
        }
        finally {
            this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
        }
    }

    @Override
    public void reindexTable(String tableName) throws ManifoldCFException {
    }

    protected void analyzeTableInternal(String tableName) throws ManifoldCFException {
        if (this.getTransactionID() == null) {
            this.performModification("ANALYZE TABLE " + tableName, null, null);
        } else {
            this.tablesToAnalyze.add(tableName);
        }
    }

    @Override
    public void performDrop(String tableName, StringSet invalidateKeys) throws ManifoldCFException {
        this.performModification("DROP TABLE " + tableName, null, invalidateKeys);
    }

    @Override
    public void createUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        block9: {
            String client = this.lockManager.getSharedConfiguration().getProperty(mysqlClientProperty);
            if (client == null || client.length() == 0) {
                client = "localhost";
            }
            DBInterfaceMySQL masterDatabase = new DBInterfaceMySQL(this.context, this.getJdbcDriverClass(), "mysql", adminUserName, adminPassword);
            try {
                ArrayList<String> list;
                block8: {
                    list = new ArrayList<String>();
                    try {
                        list.add("utf8");
                        list.add("utf8_bin");
                        masterDatabase.executeQuery("CREATE DATABASE " + this.databaseName + " CHARACTER SET ? COLLATE ?", list, null, invalidateKeys, null, false, 0, null, null);
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() == 4) break block8;
                        throw new ManifoldCFException(e.getMessage());
                    }
                }
                if (this.userName == null) break block9;
                try {
                    list.clear();
                    list.add(this.userName);
                    list.add(client);
                    list.add(this.password);
                    masterDatabase.executeQuery("GRANT ALL ON " + this.databaseName + ".* TO ?@? IDENTIFIED BY ?", list, null, invalidateKeys, null, false, 0, null, null);
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() != 4) {
                        throw new ManifoldCFException(e.getMessage());
                    }
                }
            }
            catch (ManifoldCFException e) {
                throw this.reinterpretException(e);
            }
        }
    }

    @Override
    public void dropUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        DBInterfaceMySQL masterDatabase = new DBInterfaceMySQL(this.context, this.getJdbcDriverClass(), "mysql", adminUserName, adminPassword);
        try {
            masterDatabase.executeQuery("DROP DATABASE " + this.databaseName, null, null, invalidateKeys, null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public void performModification(String query, List params, StringSet invalidateKeys) throws ManifoldCFException {
        try {
            this.executeQuery(query, params, null, invalidateKeys, null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public Map<String, ColumnDescription> getTableSchema(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        StringBuilder query = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.databaseName.toLowerCase(Locale.ROOT));
        list.add(tableName.toLowerCase(Locale.ROOT));
        query.append("SELECT column_name, is_nullable, data_type, character_maximum_length ").append("FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME=?");
        IResultSet set = this.performQuery(query.toString(), list, cacheKeys, queryClass);
        if (set.getRowCount() == 0) {
            return null;
        }
        query = new StringBuilder();
        query.append("SELECT t1.column_name ").append("FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE t1, INFORMATION_SCHEMA.TABLE_CONSTRAINTS t2 ").append("WHERE t1.CONSTRAINT_NAME=t2.CONSTRAINT_NAME AND t1.TABLE_NAME=t2.TABLE_NAME AND ").append("t1.TABLE_SCHEMA=t2.TABLE_SCHEMA AND ").append("t1.TABLE_SCHEMA=? AND t1.TABLE_NAME=? AND t2.CONSTRAINT_TYPE='PRIMARY KEY'");
        IResultSet primarySet = this.performQuery(query.toString(), list, cacheKeys, queryClass);
        String primaryKey = null;
        if (primarySet.getRowCount() != 0) {
            primaryKey = ((String)primarySet.getRow(0).getValue("column_name")).toLowerCase(Locale.ROOT);
        }
        if (primaryKey == null) {
            primaryKey = "";
        }
        HashMap<String, ColumnDescription> rval = new HashMap<String, ColumnDescription>();
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String fieldName = ((String)row.getValue("column_name")).toLowerCase(Locale.ROOT);
            String type = (String)row.getValue("data_type");
            Long width = (Long)row.getValue("character_maximum_length");
            String isNullable = (String)row.getValue("is_nullable");
            boolean isPrimaryKey = primaryKey.equals(fieldName);
            boolean isNull = isNullable.equals("YES");
            String dataType = type.equals("VARCHAR") ? "VARCHAR(" + width.toString() + ")" : (type.equals("CHAR") ? "CHAR(" + width.toString() + ")" : (type.equals("LONGBLOB") ? "BLOB" : (type.equals("DOUBLE PRECISION") ? "FLOAT" : type)));
            rval.put(fieldName, new ColumnDescription(type, isPrimaryKey, isNull, null, null, false));
        }
        return rval;
    }

    @Override
    public Map<String, IndexDescription> getTableIndexes(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        HashMap<String, IndexDescription> rval = new HashMap<String, IndexDescription>();
        String query = "SELECT index_name,column_name,non_unique,seq_in_index FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? ORDER BY index_name,seq_in_index ASC";
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.databaseName.toLowerCase(Locale.ROOT));
        list.add(tableName.toLowerCase(Locale.ROOT));
        IResultSet result = this.performQuery(query, list, cacheKeys, queryClass);
        String lastIndexName = null;
        ArrayList<String> indexColumns = null;
        boolean isUnique = false;
        int i = 0;
        while (i < result.getRowCount()) {
            IResultRow row = result.getRow(i++);
            String indexName = ((String)row.getValue("index_name")).toLowerCase(Locale.ROOT);
            String columnName = ((String)row.getValue("column_name")).toLowerCase(Locale.ROOT);
            String nonUnique = row.getValue("non_unique").toString();
            if (lastIndexName != null && !lastIndexName.equals(indexName)) {
                this.addIndex(rval, lastIndexName, isUnique, indexColumns);
                lastIndexName = null;
                indexColumns = null;
                isUnique = false;
            }
            if (lastIndexName == null) {
                lastIndexName = indexName;
                indexColumns = new ArrayList<String>();
                isUnique = false;
            }
            indexColumns.add(columnName);
            isUnique = nonUnique.equals("0");
        }
        if (lastIndexName != null) {
            this.addIndex(rval, lastIndexName, isUnique, indexColumns);
        }
        return rval;
    }

    protected void addIndex(Map rval, String indexName, boolean isUnique, List<String> indexColumns) {
        if (indexName.equals("primary")) {
            return;
        }
        String[] columnNames = new String[indexColumns.size()];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = indexColumns.get(i);
        }
        rval.put(indexName, new IndexDescription(isUnique, columnNames));
    }

    @Override
    public StringSet getAllTables(StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        IResultSet set = this.performQuery("SHOW TABLES", null, cacheKeys, queryClass);
        StringSetBuffer ssb = new StringSetBuffer();
        String columnName = "Tables_in_" + this.databaseName.toLowerCase(Locale.ROOT);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String value = row.getValue(columnName).toString();
            ssb.add(value);
        }
        return new StringSet(ssb);
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, -1, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass, int maxResults, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, null, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass, int maxResults, ResultSpecification resultSpec, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, resultSpec, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public String constructIndexHintClause(String tableName, IndexDescription description) throws ManifoldCFException {
        Map<String, IndexDescription> indexes = this.getTableIndexes(tableName, null, null);
        for (String indexName : indexes.keySet()) {
            IndexDescription id = indexes.get(indexName);
            if (!id.equals(description)) continue;
            return "FORCE INDEX (" + indexName + ")";
        }
        throw new ManifoldCFException("Expected index description " + description + " not found");
    }

    @Override
    public String constructDoubleCastClause(String value) {
        return value;
    }

    @Override
    public String constructCountClause(String column) {
        return "COUNT(" + column + ")";
    }

    @Override
    public String constructRegexpClause(String column, String regularExpression, boolean caseInsensitive) {
        return column + " LIKE " + regularExpression;
    }

    @Override
    public String constructSubstringClause(String column, String regularExpression, boolean caseInsensitive) {
        return regularExpression;
    }

    @Override
    public String constructOffsetLimitClause(int offset, int limit, boolean afterOrderBy) {
        StringBuilder sb = new StringBuilder();
        if (limit != -1) {
            sb.append("LIMIT ").append(Integer.toString(limit));
        }
        if (offset != 0) {
            if (limit != -1) {
                sb.append(" ");
            }
            sb.append("OFFSET ").append(Integer.toString(offset));
        }
        return sb.toString();
    }

    @Override
    public String constructDistinctOnClause(List outputParameters, String baseQuery, List baseParameters, String[] distinctFields, String[] orderFields, boolean[] orderFieldsAscending, Map<String, String> otherFields) {
        if (baseParameters != null) {
            outputParameters.addAll(baseParameters);
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        boolean needComma = false;
        for (String fieldName : otherFields.keySet()) {
            String columnValue = otherFields.get(fieldName);
            if (needComma) {
                sb.append(",");
            }
            needComma = true;
            sb.append("txxx1.").append(columnValue).append(" AS ").append(fieldName);
        }
        sb.append(" FROM (").append(baseQuery).append(") txxx1");
        if (distinctFields.length > 0 || orderFields.length > 0) {
            int i;
            sb.append(" ORDER BY ");
            int k = 0;
            for (i = 0; i < distinctFields.length; ++i) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(distinctFields[i]).append(" ASC");
                ++k;
            }
            i = 0;
            while (i < orderFields.length) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(orderFields[i]).append(" ");
                if (orderFieldsAscending[i]) {
                    sb.append("ASC");
                } else {
                    sb.append("DESC");
                }
                ++i;
                ++k;
            }
        }
        return sb.toString();
    }

    @Override
    public int getMaxInClause() {
        return 100;
    }

    @Override
    public int getMaxOrClause() {
        return 25;
    }

    @Override
    public int getWindowedReportMaxRows() {
        return 5000;
    }

    @Override
    public void beginTransaction() throws ManifoldCFException {
        this.beginTransaction(0);
    }

    protected int getActualTransactionType() {
        if (this.th == null) {
            return -1;
        }
        return this.th.getTransactionType();
    }

    @Override
    public void beginTransaction(int transactionType) throws ManifoldCFException {
        if (this.getCurrentTransactionType() == 2) {
            ++this.serializableDepth;
            return;
        }
        if (transactionType == 0) {
            transactionType = this.getCurrentTransactionType();
        }
        switch (transactionType) {
            case 3: {
                if (transactionType != this.getActualTransactionType()) {
                    this.performModification("SET TRANSACTION ISOLATION LEVEL REPEATABLE READ", null, null);
                }
                super.beginTransaction(transactionType);
                break;
            }
            case 1: {
                if (transactionType != this.getActualTransactionType()) {
                    this.performModification("SET TRANSACTION ISOLATION LEVEL READ COMMITTED", null, null);
                }
                super.beginTransaction(transactionType);
                break;
            }
            case 2: {
                if (transactionType != this.getActualTransactionType()) {
                    this.performModification("SET TRANSACTION ISOLATION LEVEL SERIALIZABLE", null, null);
                }
                super.beginTransaction(2);
                break;
            }
            default: {
                throw new ManifoldCFException("Bad transaction type: " + Integer.toString(transactionType));
            }
        }
    }

    @Override
    protected void startATransaction() throws ManifoldCFException {
        try {
            this.executeViaThread(this.connection.getConnection(), "START TRANSACTION", null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    protected void commitCurrentTransaction() throws ManifoldCFException {
        try {
            this.executeViaThread(this.connection.getConnection(), "COMMIT", null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public void signalRollback() {
        if (this.serializableDepth == 0) {
            super.signalRollback();
        }
    }

    @Override
    public void endTransaction() throws ManifoldCFException {
        if (this.serializableDepth > 0) {
            --this.serializableDepth;
            return;
        }
        super.endTransaction();
        if (this.getTransactionID() == null) {
            for (int i = 0; i < this.tablesToAnalyze.size(); ++i) {
                this.analyzeTableInternal(this.tablesToAnalyze.get(i));
            }
            this.tablesToAnalyze.clear();
        }
    }

    @Override
    protected void rollbackCurrentTransaction() throws ManifoldCFException {
        try {
            this.executeViaThread(this.connection.getConnection(), "ROLLBACK", null, false, 0, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void noteModificationsNoTransactions(String tableName, int insertCount, int modifyCount, int deleteCount) throws ManifoldCFException {
        block11: {
            int eventCount = modifyCount + insertCount;
            String tableStatisticsLock = statslockAnalyzePrefix + tableName;
            this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
            try {
                int analyzeThreshold;
                Integer threshold = analyzeThresholds.get(tableName);
                if (threshold == null) {
                    analyzeThreshold = this.lockManager.getSharedConfiguration().getIntProperty("org.apache.manifoldcf.db.mysql.analyze." + tableName, 10000);
                    analyzeThresholds.put(tableName, new Integer(analyzeThreshold));
                } else {
                    analyzeThreshold = threshold;
                }
                TableStatistics ts = currentAnalyzeStatistics.get(tableName);
                if (ts == null) {
                    ts = new TableStatistics();
                    currentAnalyzeStatistics.put(tableName, ts);
                }
                ts.add(eventCount);
                if (ts.getEventCount() < 100) break block11;
                this.lockManager.enterWriteLock(tableStatisticsLock);
                try {
                    String eventDatum = statsAnalyzePrefix + tableName;
                    int oldEventCount = this.readDatum(eventDatum);
                    if ((oldEventCount += ts.getEventCount()) >= analyzeThreshold) {
                        this.analyzeTableInternal(tableName);
                        this.writeDatum(eventDatum, 0);
                    } else {
                        this.writeDatum(eventDatum, oldEventCount);
                    }
                    ts.reset();
                }
                finally {
                    this.lockManager.leaveWriteLock(tableStatisticsLock);
                }
            }
            finally {
                this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
            }
        }
    }

    protected static class TableStatistics {
        protected int eventCount = 0;

        public void reset() {
            this.eventCount = 0;
        }

        public void add(int eventCount) {
            this.eventCount += eventCount;
        }

        public int getEventCount() {
            return this.eventCount;
        }
    }
}

