/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnection;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnector;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.NotificationConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.NotificationConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class JobResetThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: JobResetThread.java 991295 2010-08-31 19:12:14Z kwright $";
    protected final String processID;

    public JobResetThread(String processID) throws ManifoldCFException {
        this.setName("Job reset thread");
        this.setDaemon(true);
        this.processID = processID;
    }

    @Override
    public void run() {
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(threadContext);
            INotificationConnectionManager notificationManager = NotificationConnectionManagerFactory.make(threadContext);
            INotificationConnectorPool notificationPool = NotificationConnectorPoolFactory.make(threadContext);
            while (true) {
                try {
                    while (true) {
                        IJobDescription desc;
                        int k;
                        long currentTime = System.currentTimeMillis();
                        ArrayList<IJobDescription> jobStops = new ArrayList<IJobDescription>();
                        ArrayList<Integer> jobStopNotifications = new ArrayList<Integer>();
                        jobManager.finishJobStops(currentTime, jobStops, jobStopNotifications);
                        ArrayList<IJobDescription> jobResumes = new ArrayList<IJobDescription>();
                        jobManager.finishJobResumes(currentTime, jobResumes);
                        ArrayList<IJobDescription> jobCompletions = new ArrayList<IJobDescription>();
                        jobManager.resetJobs(currentTime, jobCompletions);
                        if (jobStops.size() > 0) {
                            Logging.threads.debug((Object)"Job reset thread reprioritizing documents...");
                            ManifoldCF.resetAllDocumentPriorities(threadContext, this.processID);
                            Logging.threads.debug((Object)"Job reset thread done reprioritizing documents.");
                        }
                        for (k = 0; k < jobStops.size(); ++k) {
                            desc = (IJobDescription)jobStops.get(k);
                            Integer notificationType = (Integer)jobStopNotifications.get(k);
                            connectionManager.recordHistory(desc.getConnectionName(), null, "job stop", null, desc.getID().toString() + "(" + desc.getDescription() + ")", null, null, null);
                            JobResetThread.doStopNotifications(desc, notificationType, notificationManager, notificationPool);
                        }
                        k = 0;
                        while (k < jobResumes.size()) {
                            desc = (IJobDescription)jobResumes.get(k++);
                            connectionManager.recordHistory(desc.getConnectionName(), null, "job continue", null, desc.getID().toString() + "(" + desc.getDescription() + ")", null, null, null);
                        }
                        k = 0;
                        while (k < jobCompletions.size()) {
                            desc = (IJobDescription)jobCompletions.get(k++);
                            connectionManager.recordHistory(desc.getConnectionName(), null, "job end", null, desc.getID().toString() + "(" + desc.getDescription() + ")", null, null, null);
                            JobResetThread.doEndNotifications(desc, notificationManager, notificationPool);
                        }
                        ManifoldCF.sleep((long)10000L);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        Logging.threads.error((Object)("Job reset thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    ManifoldCF.systemExit((int)1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    ManifoldCF.systemExit((int)-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("JobResetThread initialization error tossed: " + e.getMessage()), e);
            ManifoldCF.systemExit((int)-300);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected static void doStopNotifications(IJobDescription jobDescription, int notificationType, INotificationConnectionManager notificationManager, INotificationConnectorPool notificationPool) throws ManifoldCFException {
        block13: for (j = 0; j < jobDescription.countNotifications(); ++j) {
            notificationConnectionName = jobDescription.getNotificationConnectionName(j);
            try {
                c = notificationManager.load(notificationConnectionName);
                if (c == null || (connector = notificationPool.grab(c)) == null) continue;
                try {
                    switch (notificationType) {
                        case 0: {
                            connector.notifyOfJobStopErrorAbort(jobDescription.getNotificationSpecification(j));
                            ** break;
lbl11:
                            // 1 sources

                            continue block13;
                        }
                        case 1: {
                            connector.notifyOfJobStopManualAbort(jobDescription.getNotificationSpecification(j));
                            ** break;
lbl15:
                            // 1 sources

                            continue block13;
                        }
                        case 2: {
                            connector.notifyOfJobStopManualPause(jobDescription.getNotificationSpecification(j));
                            ** break;
lbl19:
                            // 1 sources

                            continue block13;
                        }
                        case 3: {
                            connector.notifyOfJobStopSchedulePause(jobDescription.getNotificationSpecification(j));
                            ** break;
lbl23:
                            // 1 sources

                            continue block13;
                        }
                        case 4: {
                            connector.notifyOfJobStopRestart(jobDescription.getNotificationSpecification(j));
                            ** break;
lbl27:
                            // 1 sources

                            continue block13;
                        }
                        default: {
                            throw new RuntimeException("Unhandled notification type: " + notificationType);
                        }
                    }
                }
                finally {
                    notificationPool.release(c, connector);
                }
            }
            catch (ServiceInterruption e) {
                Logging.connectors.warn((Object)("Can't notify right now: " + e.getMessage()), (Throwable)e);
                continue;
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    throw e;
                }
                Logging.connectors.warn((Object)("Error notifying: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doEndNotifications(IJobDescription jobDescription, INotificationConnectionManager notificationManager, INotificationConnectorPool notificationPool) throws ManifoldCFException {
        for (int j = 0; j < jobDescription.countNotifications(); ++j) {
            String notificationConnectionName = jobDescription.getNotificationConnectionName(j);
            try {
                INotificationConnector connector;
                INotificationConnection c = notificationManager.load(notificationConnectionName);
                if (c == null || (connector = notificationPool.grab(c)) == null) continue;
                try {
                    connector.notifyOfJobEnd(jobDescription.getNotificationSpecification(j));
                    continue;
                }
                finally {
                    notificationPool.release(c, connector);
                }
            }
            catch (ServiceInterruption e) {
                Logging.connectors.warn((Object)("Can't notify right now: " + e.getMessage()), (Throwable)e);
                continue;
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    throw e;
                }
                Logging.connectors.warn((Object)("Error notifying: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

