/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;

public class CappedInputStream
extends InputStream {
    private InputStream stream;
    private long max;
    private long counter;

    public CappedInputStream(InputStream stream, long max) {
        this.stream = stream;
        this.max = max;
        this.counter = 0L;
    }

    public long getCounter() {
        return this.counter;
    }

    public void deductBytes(int byteCount) {
        this.counter -= (long)byteCount;
    }

    public void deductString(String s, String encoding) throws UnsupportedEncodingException {
        this.counter = encoding == null ? (this.counter -= (long)s.getBytes("UTF-8").length) : (this.counter -= (long)s.getBytes(encoding).length);
    }

    private void checkLength() throws IOException {
        if (this.counter > this.max) {
            throw new CmisInvalidArgumentException("Limit exceeded!");
        }
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        this.checkLength();
        int b = this.stream.read();
        if (b > -1) {
            ++this.counter;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkLength();
        int l = this.stream.read(b, off, len);
        this.counter += (long)l;
        return l;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkLength();
        int l = this.stream.read(b);
        this.counter += (long)l;
        return l;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkLength();
        long l = this.stream.skip(n);
        this.counter += l;
        return l;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

