/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import java.util.Formatter;
import java.util.zip.CRC32;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.grib1.Grib1ParamLevel;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTableReader;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public final class Grib1SectionProductDefinition {
    private final byte[] rawData;
    private Grib1ParamTime ptime;

    public Grib1SectionProductDefinition(RandomAccessFile raf) throws IOException {
        int length = GribNumbers.uint3(raf);
        this.rawData = new byte[length];
        raf.skipBytes(-3);
        raf.readFully(this.rawData);
    }

    public Grib1SectionProductDefinition(byte[] rawData) {
        this.rawData = rawData;
    }

    public byte[] getRawBytes() {
        return this.rawData;
    }

    public int getLength() {
        return GribNumbers.uint3(this.getOctet(1), this.getOctet(2), this.getOctet(3));
    }

    public final int getTableVersion() {
        return this.getOctet(4);
    }

    public final int getCenter() {
        return this.getOctet(5);
    }

    public final int getGenProcess() {
        return this.getOctet(6);
    }

    public final int getGridDefinition() {
        return this.getOctet(7);
    }

    public final int getFlag() {
        return this.getOctet(8);
    }

    public final int getParameterNumber() {
        return this.getOctet(9);
    }

    public final int getLevelType() {
        return this.getOctet(10);
    }

    public final int getLevelValue1() {
        return this.getOctet(11);
    }

    public final int getLevelValue2() {
        return this.getOctet(12);
    }

    public final CalendarDate getReferenceDate() {
        int century = this.getReferenceCentury() - 1;
        if (century == -1) {
            century = 20;
        }
        int year = this.getOctet(13);
        int month = this.getOctet(14);
        int day = this.getOctet(15);
        int hour = this.getOctet(16);
        int minute = this.getOctet(17);
        return CalendarDate.of(null, century * 100 + year, month, day, hour, minute, 0);
    }

    public final int getTimeUnit() {
        return this.getOctet(18);
    }

    public final int getTimeValue1() {
        return this.getOctet(19);
    }

    public final int getTimeValue2() {
        return this.getOctet(20);
    }

    public final int getTimeRangeIndicator() {
        return this.getOctet(21);
    }

    public final int getNincluded() {
        return GribNumbers.int2(this.getOctet(22), this.getOctet(23));
    }

    public final int getNmissing() {
        return this.getOctet(24);
    }

    public final int getReferenceCentury() {
        return this.getOctet(25);
    }

    public final int getSubCenter() {
        return this.getOctet(26);
    }

    public final int getDecimalScale() {
        return GribNumbers.int2(this.getOctet(27), this.getOctet(28));
    }

    public final boolean gdsExists() {
        return (this.getFlag() & 0x80) == 128;
    }

    public final boolean bmsExists() {
        return (this.getFlag() & 0x40) == 64;
    }

    private int getOctet(int index) {
        if (index > this.rawData.length) {
            return -9999;
        }
        return this.rawData[index - 1] & 0xFF;
    }

    public Grib1ParamTime getParamTime(Grib1Customizer cust) {
        if (this.ptime == null) {
            this.ptime = new Grib1ParamTime(cust, this);
        }
        return this.ptime;
    }

    private String getCalendarPeriodAsString() {
        try {
            return GribUtils.getCalendarPeriod(this.getTimeUnit()).toString();
        }
        catch (UnsupportedOperationException e) {
            return "Unknown Time Unit";
        }
    }

    public void showPds(Grib1Customizer cust, Formatter f) {
        f.format("            Originating Center : (%d) %s%n", this.getCenter(), CommonCodeTable.getCenterName(this.getCenter(), 1));
        f.format("         Originating SubCenter : (%d) %s%n", this.getSubCenter(), cust.getSubCenterName(this.getSubCenter()));
        f.format("                 Table Version : %d%n", this.getTableVersion());
        Grib1Parameter parameter = cust.getParameter(this.getCenter(), this.getSubCenter(), this.getTableVersion(), this.getParameterNumber());
        if (parameter != null) {
            Grib1ParamTableReader ptable = parameter.getTable();
            f.format("               Parameter Table : (%d-%d-%d) %s%n", this.getCenter(), this.getSubCenter(), this.getTableVersion(), ptable == null ? "MISSING" : ptable.getPath());
            f.format("                Parameter Name : (%d) %s%n", this.getParameterNumber(), parameter.getName());
            f.format("                Parameter Desc : %s%n", parameter.getDescription());
            f.format("               Parameter Units : %s%n", parameter.getUnit());
        } else {
            f.format("               Parameter %d not found%n", this.getParameterNumber());
        }
        f.format("       Generating Process Type : (%d) %s%n", this.getGenProcess(), cust.getGeneratingProcessName(this.getGenProcess()));
        f.format("                Reference Time : %s%n", this.getReferenceDate());
        f.format("                    Time Units : (%d) %s%n", this.getTimeUnit(), this.getCalendarPeriodAsString());
        Grib1ParamTime ptime = this.getParamTime(cust);
        f.format("          Time Range Indicator : (%d) %s%n", this.getTimeRangeIndicator(), ptime.getTimeTypeName());
        f.format("                   Time 1 (P1) : %d%n", this.getTimeValue1());
        f.format("                   Time 2 (P2) : %d%n", this.getTimeValue2());
        f.format("                   Time  coord : %s%n", ptime.getTimeCoord());
        Grib1ParamLevel plevel = cust.getParamLevel(this);
        f.format("                    Level Type : (%d) %s%n", this.getLevelType(), plevel.getNameShort());
        f.format("             Level Description : %s%n", plevel.getDescription());
        f.format("                 Level Value 1 : %f%n", Float.valueOf(plevel.getValue1()));
        f.format("                 Level Value 2 : %f%n", Float.valueOf(plevel.getValue2()));
        f.format("               Grid Definition : %d%n", this.getGridDefinition());
        f.format("                    GDS Exists : %s%n", this.gdsExists());
        f.format("                    BMS Exists : %s%n", this.bmsExists());
        f.format("          Decimal Scale Factor : %d%n", this.getDecimalScale());
    }

    public boolean isEnsemble() {
        switch (this.getCenter()) {
            case 7: {
                return this.rawData.length >= 43 && this.getOctet(41) == 1;
            }
            case 98: {
                return !(this.rawData.length < 51 || this.getOctet(41) != 1 && this.getOctet(41) != 30 || this.getOctet(43) != 10 && this.getOctet(43) != 11);
            }
        }
        return false;
    }

    public final int getPerturbationType() {
        if (!this.isEnsemble()) {
            return -9999;
        }
        switch (this.getCenter()) {
            case 7: {
                return this.getOctet(42);
            }
            case 98: {
                return this.getOctet(43);
            }
        }
        return -9999;
    }

    public final int getPerturbationNumber() {
        if (!this.isEnsemble()) {
            return -9999;
        }
        switch (this.getCenter()) {
            case 7: {
                int type = this.getOctet(42);
                int id = this.getOctet(43);
                if (type == 1) {
                    return 0;
                }
                if (type == 2) {
                    return id;
                }
                if (type == 3) {
                    return 5 + id;
                }
            }
            case 98: {
                return this.getOctet(50);
            }
        }
        return -9999;
    }

    public long calcCRC() {
        CRC32 crc32 = new CRC32();
        crc32.update(this.rawData);
        return crc32.getValue();
    }
}

