/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.net.mock;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import org.apache.logging.log4j.core.test.net.mock.MockSyslogServer;
import org.apache.logging.log4j.core.util.Throwables;

public class MockUdpSyslogServer
extends MockSyslogServer {
    private final DatagramSocket socket;
    private volatile boolean shutdown = false;
    private Thread thread;

    public MockUdpSyslogServer(int numberOfMessagesToReceive, int port) throws SocketException {
        this(port);
    }

    public MockUdpSyslogServer() throws SocketException {
        this(0);
    }

    private MockUdpSyslogServer(int port) throws SocketException {
        super(0, port);
        this.socket = new DatagramSocket(port);
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Shutdown of {} thread failed.", (Object)this.getName(), (Object)e);
            }
        }
    }

    @Override
    public void run() {
        block3: {
            LOGGER.info("{} started on port {}.", (Object)this.getName(), (Object)this.getLocalPort());
            this.thread = Thread.currentThread();
            byte[] bytes = new byte[4096];
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            try {
                while (!this.shutdown) {
                    this.socket.receive(packet);
                    String message = new String(packet.getData(), 0, packet.getLength());
                    LOGGER.debug("{} received a message: {}", (Object)this.getName(), (Object)message);
                    this.messageList.add(message);
                }
            }
            catch (Exception e) {
                if (this.shutdown) break block3;
                Throwables.rethrow((Throwable)e);
            }
        }
        LOGGER.info("{} stopped.", (Object)this.getName());
    }
}

