/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.converter;

import java.util.ArrayList;
import org.apache.logging.log4j.catalog.api.Category;
import org.apache.logging.log4j.catalog.jpa.model.CategoryModel;
import org.apache.logging.log4j.catalog.jpa.model.EventModel;
import org.apache.logging.log4j.catalog.jpa.service.EventService;
import org.modelmapper.AbstractConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CategoryModelConverter
extends AbstractConverter<CategoryModel, Category> {
    @Autowired
    private EventService eventService;

    public Category convert(CategoryModel categoryModel) {
        Category category = new Category();
        category.setId(categoryModel.getId());
        category.setCatalogId(categoryModel.getCatalogId());
        category.setName(categoryModel.getName());
        category.setDisplayName(categoryModel.getDisplayName());
        category.setDescription(categoryModel.getDescription());
        ArrayList<String> events = new ArrayList<String>(categoryModel.getEvents().size());
        for (EventModel event : categoryModel.getEvents()) {
            events.add(event.getName());
        }
        category.setEvents(events);
        return category;
    }
}

