/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.prefs;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.MRUFileList;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;
import org.apache.log4j.chainsaw.prefs.SettingsManager;

public class MRUFileListPreferenceSaver
implements SettingsListener {
    private static final MRUFileListPreferenceSaver instance = new MRUFileListPreferenceSaver();

    public static final MRUFileListPreferenceSaver getInstance() {
        return instance;
    }

    private MRUFileListPreferenceSaver() {
    }

    @Override
    public void loadSettings(LoadSettingsEvent event) {
        File file = this.getMRULocation(SettingsManager.getInstance().getSettingsDirectory());
        if (file.exists()) {
            try {
                MRUFileList.loadLog4jMRUListFromReader(new FileReader(file));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void saveSettings(SaveSettingsEvent event) {
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        try {
            File file = this.getMRULocation(event.getSettingsLocation());
            System.out.println("Writing MRU ->" + file.getAbsolutePath());
            FileWriter writer = new FileWriter(file);
            stream.toXML((Object)MRUFileList.log4jMRU(), (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getMRULocation(File dir) {
        File file = new File(dir, "mru.xml");
        return file;
    }
}

