/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.helper;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class SwingHelper {
    public static void centerOnScreen(Component component) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        component.setLocation(screenSize.width / 2 - component.getWidth() / 2, screenSize.height / 2 - component.getHeight() / 2);
    }

    public static void configureCancelForDialog(final JDialog dialog, JButton cancelButton) {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = dialog.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction closeAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                dialog.dispose();
            }
        };
        cancelButton.setAction(closeAction);
        dialog.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, closeAction);
    }

    public static void invokeOnEDT(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static boolean isMacOSX() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("mac os x");
    }

    public static List orderOKCancelButtons(JButton okButton, JButton cancelButton) {
        ArrayList<JButton> result = new ArrayList<JButton>();
        if (SwingHelper.isMacOSX()) {
            result.add(cancelButton);
            result.add(okButton);
        } else {
            result.add(okButton);
            result.add(cancelButton);
        }
        return result;
    }

    public static File promptForFile(Container parent, String defaultPath, String title, boolean loadDialog) {
        if (SwingHelper.isMacOSX()) {
            Component root = SwingUtilities.getRoot(parent);
            Frame frame = null;
            if (root instanceof Frame) {
                frame = (Frame)root;
            }
            FileDialog fileDialog = new FileDialog(frame, title);
            fileDialog.setModal(true);
            fileDialog.setMode(loadDialog ? 0 : 1);
            if (defaultPath != null) {
                fileDialog.setDirectory(defaultPath);
            }
            fileDialog.setVisible(true);
            String fileString = fileDialog.getFile();
            if (fileString == null) {
                return null;
            }
            if (fileDialog.getDirectory() != null) {
                return new File(fileDialog.getDirectory(), fileString);
            }
            return new File(fileString);
        }
        JFileChooser chooser = defaultPath != null ? new JFileChooser(defaultPath) : new JFileChooser();
        chooser.setDialogTitle(title);
        chooser.setAcceptAllFileFilterUsed(true);
        int i = loadDialog ? chooser.showOpenDialog(parent) : chooser.showSaveDialog(parent);
        if (i != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }
}

