/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.internal.impl.DefaultLocalPathPrefixComposerFactory;
import shaded.org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManager;
import shaded.org.eclipse.aether.internal.impl.LocalPathComposer;
import shaded.org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import shaded.org.eclipse.aether.internal.impl.TrackingFileManager;
import shaded.org.eclipse.aether.repository.LocalRepository;
import shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import shaded.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import shaded.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.spi.locator.Service;
import shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import shaded.org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named(value="enhanced")
public class EnhancedLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    public static final String NAME = "enhanced";
    private static final String CONFIG_PROP_TRACKING_FILENAME = "aether.enhancedLocalRepository.trackingFilename";
    private static final String DEFAULT_TRACKING_FILENAME = "_remote.repositories";
    private float priority = 10.0f;
    private LocalPathComposer localPathComposer;
    private TrackingFileManager trackingFileManager;
    private LocalPathPrefixComposerFactory localPathPrefixComposerFactory;

    @Deprecated
    public EnhancedLocalRepositoryManagerFactory() {
    }

    @Inject
    public EnhancedLocalRepositoryManagerFactory(LocalPathComposer localPathComposer, TrackingFileManager trackingFileManager, LocalPathPrefixComposerFactory localPathPrefixComposerFactory) {
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
        this.trackingFileManager = Objects.requireNonNull(trackingFileManager);
        this.localPathPrefixComposerFactory = Objects.requireNonNull(localPathPrefixComposerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.localPathComposer = Objects.requireNonNull(locator.getService(LocalPathComposer.class));
        this.trackingFileManager = Objects.requireNonNull(locator.getService(TrackingFileManager.class));
        this.localPathPrefixComposerFactory = new DefaultLocalPathPrefixComposerFactory();
    }

    @Override
    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        String trackingFilename = ConfigUtils.getString(session, "", CONFIG_PROP_TRACKING_FILENAME);
        if (trackingFilename.isEmpty() || trackingFilename.contains("/") || trackingFilename.contains("\\") || trackingFilename.contains("..")) {
            trackingFilename = DEFAULT_TRACKING_FILENAME;
        }
        if ("".equals(repository.getContentType()) || "default".equals(repository.getContentType())) {
            return new EnhancedLocalRepositoryManager(repository.getBasedir(), this.localPathComposer, trackingFilename, this.trackingFileManager, this.localPathPrefixComposerFactory.createComposer(session));
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public EnhancedLocalRepositoryManagerFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

