/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.FilterConfigImpl;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.runtime.FilterInfo;

public abstract class FilterHandler
implements Comparable<FilterHandler> {
    private final long contextServiceId;
    private final FilterInfo filterInfo;
    private final ExtServletContext context;
    private volatile Filter filter;
    protected volatile int useCount;

    public FilterHandler(long contextServiceId, ExtServletContext context, FilterInfo filterInfo) {
        this.contextServiceId = contextServiceId;
        this.context = context;
        this.filterInfo = filterInfo;
    }

    @Override
    public int compareTo(FilterHandler other) {
        return this.filterInfo.compareTo(other.filterInfo);
    }

    public long getContextServiceId() {
        return this.contextServiceId;
    }

    public ExtServletContext getContext() {
        return this.context;
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected void setFilter(Filter f) {
        this.filter = f;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public String getName() {
        String name = this.filterInfo.getName();
        if (name == null && this.filter != null) {
            name = this.filter.getClass().getName();
        }
        return name;
    }

    public int init() {
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        if (this.filter == null) {
            return 5;
        }
        try {
            this.filter.init((FilterConfig)new FilterConfigImpl(this.getName(), this.getContext(), this.getFilterInfo().getInitParameters()));
        }
        catch (Exception e) {
            SystemLogger.error(this.getFilterInfo().getServiceReference(), "Error during calling init() on filter " + this.filter, e);
            return 4;
        }
        ++this.useCount;
        return -1;
    }

    public void handle(@Nonnull ServletRequest req, @Nonnull ServletResponse res, @Nonnull FilterChain chain) throws ServletException, IOException {
        this.filter.doFilter(req, res, chain);
    }

    public boolean destroy() {
        if (this.filter == null) {
            return false;
        }
        --this.useCount;
        if (this.useCount == 0) {
            try {
                this.filter.destroy();
            }
            catch (Exception ignore) {
                SystemLogger.error(this.getFilterInfo().getServiceReference(), "Error during calling destroy() on filter " + this.filter, ignore);
            }
            this.filter = null;
            return true;
        }
        return false;
    }

    public boolean dispose() {
        this.useCount = 1;
        return this.destroy();
    }

    public int hashCode() {
        return 31 + this.filterInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FilterHandler other = (FilterHandler)obj;
        return this.filterInfo.equals(other.filterInfo);
    }
}

