/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.jline;

import org.apache.felix.gogo.api.CommandSessionListener;
import org.apache.felix.service.command.CommandSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCommandSessionListener
implements CommandSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingCommandSessionListener.class);

    @Override
    public void beforeExecute(CommandSession session, CharSequence command) {
        LOGGER.debug("Executing command: '" + command + "'");
    }

    @Override
    public void afterExecute(CommandSession session, CharSequence command, Exception exception) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.debug("Command: '" + command + "' failed", (Throwable)exception);
        } else {
            LOGGER.debug("Command: '" + command + "' failed: " + exception);
        }
    }

    @Override
    public void afterExecute(CommandSession session, CharSequence command, Object result) {
        LOGGER.debug("Command: '" + command + "' returned '" + result + "'");
    }
}

