/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.slider;

import com.github.weisj.darklaf.ui.slider.DarkSliderUI;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;

public class DarkSliderListener
extends MouseAdapter
implements PropertyChangeListener {
    private final DarkSliderUI ui;
    private final JSlider slider;
    private boolean muted = false;
    private int oldValue;

    public DarkSliderListener(DarkSliderUI ui, JSlider slider) {
        this.ui = ui;
        this.slider = slider;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        super.mouseWheelMoved(e);
        if (!this.slider.hasFocus()) {
            return;
        }
        if (e.getScrollType() == 1) {
            return;
        }
        int amount = e.getWheelRotation();
        boolean ltr = this.slider.getComponentOrientation().isLeftToRight();
        if (ltr) {
            amount *= -1;
        }
        if (this.slider.getSnapToTicks()) {
            int spacing = this.slider.getMinorTickSpacing();
            amount *= spacing;
        }
        this.ui.setValue(this.slider.getValue() + amount, true);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.slider.isEnabled() && this.ui.showVolumeIcon(this.slider) && this.ui.iconRect.contains(e.getPoint())) {
            if (this.muted && this.slider.getValue() == this.slider.getMinimum()) {
                this.ui.setValue(this.oldValue, true);
                this.muted = false;
            } else {
                this.oldValue = this.slider.getValue();
                this.ui.setValue(this.slider.getMinimum(), true);
                this.muted = true;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("JSlider.variant".equals(key) || "JSlider.volume.showIcon".equals(key) || "orientation".equals(key) || "componentOrientation".equals(key)) {
            this.ui.updateVisualPaddings();
            this.slider.repaint();
        }
    }
}

