/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.gui.BindingGroup;
import org.apache.jmeter.gui.JBooleanPropertyEditor;
import org.apache.jmeter.gui.JCheckBoxBinding;
import org.apache.jmeter.gui.JLabeledFieldBinding;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.protocol.http.config.gui.AbstractValidationTabbedPane;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigDefaults;
import org.apache.jmeter.protocol.http.gui.HTTPArgumentsPanel;
import org.apache.jmeter.protocol.http.gui.HTTPFileArgsPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBaseSchema;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JEditableCheckBox;
import org.apache.jorphan.gui.JFactory;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledField;
import org.apache.jorphan.gui.JLabeledTextField;

public class UrlConfigGui
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 240L;
    private static final UrlConfigDefaults URL_CONFIG_DEFAULTS = new UrlConfigDefaults();
    private static final int TAB_PARAMETERS = 0;
    private int tabRawBodyIndex = 1;
    private int tabFileUploadIndex = 2;
    private HTTPArgumentsPanel argsPanel;
    private HTTPFileArgsPanel filesPanel;
    private JLabeledTextField domain;
    private JLabeledTextField port;
    private JLabeledTextField protocol;
    private JLabeledTextField contentEncoding;
    private JLabeledTextField path;
    private JCheckBox followRedirects;
    private JCheckBox autoRedirects;
    private JBooleanPropertyEditor useKeepAlive;
    private JBooleanPropertyEditor useMultipart;
    private JBooleanPropertyEditor useBrowserCompatibleMultipartMode;
    private JLabeledChoice method;
    private final boolean notConfigOnly;
    private JSyntaxTextArea postBodyContent;
    private AbstractValidationTabbedPane postContentTabbedPane;
    private final boolean showRawBodyPane;
    private final boolean showFileUploadPane;
    private final BindingGroup bindingGroup;

    public UrlConfigGui() {
        this(true);
    }

    public UrlConfigGui(boolean showSamplerFields) {
        this(showSamplerFields, true);
    }

    public UrlConfigGui(boolean showSamplerFields, boolean showRawBodyPane) {
        this(showSamplerFields, showRawBodyPane, false);
    }

    public UrlConfigGui(boolean showSamplerFields, boolean showRawBodyPane, boolean showFileUploadPane) {
        this.notConfigOnly = showSamplerFields;
        this.showRawBodyPane = showRawBodyPane;
        this.showFileUploadPane = showFileUploadPane;
        this.init();
        HTTPSamplerBaseSchema.INSTANCE schema = HTTPSamplerBaseSchema.INSTANCE;
        this.bindingGroup = new BindingGroup(Arrays.asList(new JLabeledFieldBinding((JLabeledField)this.domain, schema.getDomain()), new JLabeledFieldBinding((JLabeledField)this.port, schema.getPort()), new JLabeledFieldBinding((JLabeledField)this.protocol, schema.getProtocol()), new JLabeledFieldBinding((JLabeledField)this.contentEncoding, schema.getContentEncoding()), new JLabeledFieldBinding((JLabeledField)this.path, schema.getPath())));
        if (this.notConfigOnly) {
            this.bindingGroup.addAll(Arrays.asList(new JCheckBoxBinding(this.followRedirects, schema.getFollowRedirects()), new JCheckBoxBinding(this.autoRedirects, schema.getAutoRedirects()), new JLabeledFieldBinding((JLabeledField)this.method, schema.getMethod()), this.useKeepAlive, this.useMultipart, this.useBrowserCompatibleMultipartMode));
        }
    }

    public void clear() {
        this.argsPanel.clear();
        if (this.showFileUploadPane) {
            this.filesPanel.clear();
        }
        if (this.showRawBodyPane) {
            this.postBodyContent.setInitialText("");
        }
        this.postContentTabbedPane.setSelectedIndex(0, false);
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        element.setName(this.getName());
        element.setProperty("TestElement.gui_class", this.getClass().getName());
        element.setProperty("TestElement.test_class", element.getClass().getName());
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        Arguments args;
        boolean useRaw;
        this.bindingGroup.updateElement(element);
        boolean bl = useRaw = this.showRawBodyPane && !this.postBodyContent.getText().isEmpty();
        if (useRaw) {
            args = new Arguments();
            String text = this.postBodyContent.getText();
            HTTPArgument arg = new HTTPArgument("", text.replaceAll("\n", "\r\n"), false);
            arg.setAlwaysEncoded(false);
            args.addArgument((Argument)arg);
        } else {
            args = this.argsPanel.createTestElement();
            HTTPArgument.convertArgumentsToHTTP(args);
        }
        if (this.showFileUploadPane) {
            this.filesPanel.modifyTestElement(element);
        }
        HTTPSamplerBaseSchema.INSTANCE httpSchema = HTTPSamplerBaseSchema.INSTANCE;
        element.set(httpSchema.getPostBodyRaw(), useRaw ? Boolean.TRUE : (this.notConfigOnly ? Boolean.valueOf(false) : null));
        element.set(httpSchema.getArguments(), (TestElement)args);
    }

    public void assignDefaultValues(TestElement element) {
        HTTPSamplerBase httpSampler = (HTTPSamplerBase)element;
        httpSampler.setPostBodyRaw(false);
        httpSampler.setArguments(this.argsPanel.createTestElement());
    }

    private static String computePostBody(Arguments arguments) {
        return UrlConfigGui.computePostBody(arguments, false);
    }

    private static String computePostBody(Arguments arguments, boolean crlfToLF) {
        StringBuilder postBody = new StringBuilder();
        for (JMeterProperty argument : arguments) {
            HTTPArgument arg = (HTTPArgument)argument.getObjectValue();
            String value = arg.getValue();
            if (crlfToLF) {
                value = value.replaceAll("\r\n", "\n");
            }
            postBody.append(value);
        }
        return postBody.toString();
    }

    public void configure(TestElement el) {
        this.setName(el.getName());
        this.bindingGroup.updateUi(el);
        HTTPSamplerBaseSchema.INSTANCE httpSchema = HTTPSamplerBaseSchema.INSTANCE;
        Arguments arguments = (Arguments)el.get(httpSchema.getArguments());
        if (this.showRawBodyPane) {
            boolean useRaw = el.get(httpSchema.getPostBodyRaw());
            if (useRaw) {
                String postBody = UrlConfigGui.computePostBody(arguments, true);
                this.postBodyContent.setInitialText(postBody);
                this.postBodyContent.setCaretPosition(0);
                this.argsPanel.clear();
                this.postContentTabbedPane.setSelectedIndex(this.tabRawBodyIndex, false);
            } else {
                this.postBodyContent.setInitialText("");
                this.argsPanel.configure((TestElement)arguments);
                this.postContentTabbedPane.setSelectedIndex(0, false);
            }
        }
        if (this.showFileUploadPane) {
            this.filesPanel.configure(el);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel webRequestPanel = new JPanel();
        webRequestPanel.setLayout(new BorderLayout());
        webRequestPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_request")));
        webRequestPanel.add(this.getPathPanel(), "North");
        webRequestPanel.add((Component)this.getParameterPanel(), "Center");
        this.add((Component)this.getWebServerPanel(), "North");
        this.add((Component)webRequestPanel, "Center");
    }

    protected final JPanel getWebServerPanel() {
        this.protocol = new JLabeledTextField(JMeterUtils.getResString((String)"protocol"), 4);
        this.port = new JLabeledTextField(JMeterUtils.getResString((String)"web_server_port"), 7);
        this.domain = new JLabeledTextField(JMeterUtils.getResString((String)"web_server_domain"), 40);
        HorizontalPanel webServerPanel = new HorizontalPanel();
        webServerPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_server")));
        webServerPanel.add((Component)this.protocol);
        webServerPanel.add((Component)this.domain);
        webServerPanel.add((Component)this.port);
        return webServerPanel;
    }

    protected UrlConfigDefaults getUrlConfigDefaults() {
        return URL_CONFIG_DEFAULTS;
    }

    protected Component getPathPanel() {
        this.path = new JLabeledTextField(JMeterUtils.getResString((String)"path"), 80);
        this.contentEncoding = new JLabeledTextField(JMeterUtils.getResString((String)"content_encoding"), 7);
        if (this.notConfigOnly) {
            this.method = new JLabeledChoice(JMeterUtils.getResString((String)"method"), this.getUrlConfigDefaults().getValidMethods(), true, false);
            this.method.addChangeListener((ChangeListener)this);
        }
        if (this.notConfigOnly) {
            this.followRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects"));
            JFactory.small((JCheckBox)this.followRedirects);
            this.followRedirects.addChangeListener(this);
            this.followRedirects.setVisible(this.getUrlConfigDefaults().isFollowRedirectsVisible());
            this.autoRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects_auto"));
            JFactory.small((JCheckBox)this.autoRedirects);
            this.autoRedirects.addChangeListener(this);
            this.autoRedirects.setVisible(this.getUrlConfigDefaults().isAutoRedirectsVisible());
            this.useKeepAlive = new JBooleanPropertyEditor(HTTPSamplerBaseSchema.INSTANCE.getUseKeepalive(), JMeterUtils.getResString((String)"use_keepalive"));
            JFactory.small((JEditableCheckBox)this.useKeepAlive);
            this.useKeepAlive.setVisible(this.getUrlConfigDefaults().isUseKeepAliveVisible());
            this.useMultipart = new JBooleanPropertyEditor(HTTPSamplerBaseSchema.INSTANCE.getUseMultipartPost(), JMeterUtils.getResString((String)"use_multipart_for_http_post"));
            JFactory.small((JEditableCheckBox)this.useMultipart);
            this.useMultipart.setVisible(this.getUrlConfigDefaults().isUseMultipartVisible());
            this.useBrowserCompatibleMultipartMode = new JBooleanPropertyEditor(HTTPSamplerBaseSchema.INSTANCE.getUseBrowserCompatibleMultipart(), JMeterUtils.getResString((String)"use_multipart_mode_browser"));
            JFactory.small((JEditableCheckBox)this.useBrowserCompatibleMultipartMode);
            this.useBrowserCompatibleMultipartMode.setVisible(this.getUrlConfigDefaults().isUseBrowserCompatibleMultipartModeVisible());
        }
        HorizontalPanel pathPanel = new HorizontalPanel();
        if (this.notConfigOnly) {
            pathPanel.add((Component)this.method);
        }
        pathPanel.add((Component)this.path);
        pathPanel.add((Component)this.contentEncoding);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add((Component)pathPanel);
        if (this.notConfigOnly) {
            JPanel optionPanel = new JPanel(new FlowLayout(0));
            optionPanel.add(this.autoRedirects);
            optionPanel.add(this.followRedirects);
            optionPanel.add((Component)this.useKeepAlive);
            optionPanel.add((Component)this.useMultipart);
            optionPanel.add((Component)this.useBrowserCompatibleMultipartMode);
            optionPanel.setMinimumSize(optionPanel.getPreferredSize());
            panel.add(optionPanel);
        }
        return panel;
    }

    protected JTabbedPane getParameterPanel() {
        this.postContentTabbedPane = new ValidationTabbedPane();
        this.argsPanel = new HTTPArgumentsPanel();
        this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_as_parameters"), (Component)((Object)this.argsPanel));
        int indx = 0;
        if (this.showRawBodyPane) {
            this.tabRawBodyIndex = ++indx;
            this.postBodyContent = JSyntaxTextArea.getInstance((int)30, (int)50);
            this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_body"), (Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.postBodyContent));
        }
        if (this.showFileUploadPane) {
            this.tabFileUploadIndex = ++indx;
            this.filesPanel = new HTTPFileArgsPanel();
            this.postContentTabbedPane.add(JMeterUtils.getResString((String)"post_files_upload"), this.filesPanel);
        }
        return this.postContentTabbedPane;
    }

    protected Arguments createHTTPArgumentsTestElement() {
        return this.argsPanel.createTestElement();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.autoRedirects && this.autoRedirects.isSelected()) {
            this.followRedirects.setSelected(false);
        } else if (source == this.followRedirects && this.followRedirects.isSelected()) {
            this.autoRedirects.setSelected(false);
        }
    }

    void convertParametersToRaw() {
        if (this.showRawBodyPane && this.postBodyContent.getText().isEmpty()) {
            this.postBodyContent.setInitialText(UrlConfigGui.computePostBody(this.argsPanel.createTestElement()));
            this.postBodyContent.setCaretPosition(0);
        }
    }

    class ValidationTabbedPane
    extends AbstractValidationTabbedPane {
        private static final long serialVersionUID = 7014311238367882881L;

        ValidationTabbedPane() {
        }

        @Override
        protected int getValidatedTabIndex(int currentTabIndex, int newTabIndex) {
            if (newTabIndex == UrlConfigGui.this.tabFileUploadIndex) {
                return newTabIndex;
            }
            if (newTabIndex != currentTabIndex) {
                if (newTabIndex == UrlConfigGui.this.tabRawBodyIndex) {
                    if (this.canSwitchToRawBodyPane()) {
                        UrlConfigGui.this.convertParametersToRaw();
                        return newTabIndex;
                    }
                    return 0;
                }
                if (this.canSwitchToParametersTab()) {
                    return newTabIndex;
                }
                return UrlConfigGui.this.tabRawBodyIndex;
            }
            return newTabIndex;
        }

        private boolean canSwitchToRawBodyPane() {
            Arguments arguments = UrlConfigGui.this.argsPanel.createTestElement();
            for (int i = 0; i < arguments.getArgumentCount(); ++i) {
                if (StringUtils.isEmpty((CharSequence)arguments.getArgument(i).getName())) continue;
                return false;
            }
            return true;
        }

        private boolean canSwitchToParametersTab() {
            return UrlConfigGui.this.showRawBodyPane && UrlConfigGui.this.postBodyContent.getText().isEmpty();
        }
    }
}

