/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsDefaults;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u000b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"H\u0000\u00a2\u0006\u0002\b#J\u0012\u0010$\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0012\u0010%\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0015\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020 H\u0000\u00a2\u0006\u0002\b(J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0003R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/StitchedPlotLayer;", "", "geomLayers", "", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "(Ljava/util/List;)V", "aestheticsDefaults", "Lorg/jetbrains/letsPlot/core/plot/base/aes/AestheticsDefaults;", "getAestheticsDefaults", "()Lorg/jetbrains/letsPlot/core/plot/base/aes/AestheticsDefaults;", "colorByAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getColorByAes", "()Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "fillByAes", "getFillByAes", "isLegendDisabled", "", "()Z", "isYOrientation", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getConstant", "T", "aes", "(Lorg/jetbrains/letsPlot/core/plot/base/Aes;)Ljava/lang/Object;", "getDataRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "variable", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "getVariables", "", "getVariables$plot_builder", "hasBinding", "hasConstant", "hasVariable", "v", "hasVariable$plot_builder", "isNumericData", "renderedAes", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nStitchedPlotLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StitchedPlotLayer.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/StitchedPlotLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class StitchedPlotLayer {
    @NotNull
    private final List<GeomLayer> geomLayers;

    public StitchedPlotLayer(@NotNull List<? extends GeomLayer> geomLayers) {
        Intrinsics.checkNotNullParameter(geomLayers, (String)"geomLayers");
        this.geomLayers = geomLayers;
    }

    public final boolean isYOrientation() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).isYOrientation();
    }

    @NotNull
    public final LegendKeyElementFactory getLegendKeyElementFactory() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getLegendKeyElementFactory();
    }

    @NotNull
    public final AestheticsDefaults getAestheticsDefaults() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getAestheticsDefaults();
    }

    public final boolean isLegendDisabled() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).isLegendDisabled();
    }

    @NotNull
    public final Aes<Color> getColorByAes() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getColorByAes();
    }

    @NotNull
    public final Aes<Color> getFillByAes() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getFillByAes();
    }

    @NotNull
    public final List<Aes<?>> renderedAes() {
        return this.geomLayers.isEmpty() ? CollectionsKt.emptyList() : GeomLayer.DefaultImpls.renderedAes$default(this.geomLayers.get(0), false, 1, null);
    }

    public final boolean hasBinding(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return !((Collection)this.geomLayers).isEmpty() && this.geomLayers.get(0).hasBinding(aes);
    }

    public final boolean hasConstant(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return !((Collection)this.geomLayers).isEmpty() && this.geomLayers.get(0).hasConstant(aes);
    }

    public final <T> T getConstant(@NotNull Aes<T> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getConstant(aes);
    }

    @Nullable
    public final DoubleSpan getDataRange(@NotNull DataFrame.Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (!this.isNumericData(variable)) {
            boolean bl = false;
            String string = "Not numeric data [" + variable + ']';
            throw new IllegalStateException(string.toString());
        }
        DoubleSpan result = null;
        for (GeomLayer layer : this.geomLayers) {
            DoubleSpan range = layer.getDataFrame().range(variable);
            result = SeriesUtil.INSTANCE.span(result, range);
        }
        return result;
    }

    private final boolean isNumericData(DataFrame.Variable variable) {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        for (GeomLayer layer : this.geomLayers) {
            if (layer.getDataFrame().isNumeric(variable)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Set<DataFrame.Variable> getVariables$plot_builder() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getDataFrame().variables();
    }

    public final boolean hasVariable$plot_builder(@NotNull DataFrame.Variable v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getDataFrame().has(v);
    }
}

