/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.DensityStat;
import org.jetbrains.letsPlot.core.plot.base.stat.DensityStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\u0002\u0010\u0011J;\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e0\u0019H\u0016J\u0012\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u0010H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityRidgesStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "trim", "", "tailsCutoff", "", "bandWidth", "bandWidthMethod", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$BandWidthMethod;", "adjust", "kernel", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$Kernel;", "n", "", "fullScanMax", "quantiles", "", "(ZLjava/lang/Double;Ljava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$BandWidthMethod;DLorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$Kernel;IILjava/util/List;)V", "Ljava/lang/Double;", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "normalize", "dataAfterStat", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nDensityRidgesStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DensityRidgesStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/DensityRidgesStat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1#2:92\n1549#3:93\n1620#3,3:94\n1549#3:97\n1620#3,3:98\n*S KotlinDebug\n*F\n+ 1 DensityRidgesStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/DensityRidgesStat\n*L\n71#1:93\n71#1:94,3\n73#1:97\n73#1:98,3\n*E\n"})
public final class DensityRidgesStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean trim;
    @Nullable
    private final Double tailsCutoff;
    @Nullable
    private final Double bandWidth;
    @NotNull
    private final DensityStat.BandWidthMethod bandWidthMethod;
    private final double adjust;
    @NotNull
    private final DensityStat.Kernel kernel;
    private final int n;
    private final int fullScanMax;
    @NotNull
    private final List<Double> quantiles;
    public static final boolean DEF_TRIM = false;
    @NotNull
    private static final List<Double> DEF_QUANTILES;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public DensityRidgesStat(boolean trim, @Nullable Double tailsCutoff, @Nullable Double bandWidth, @NotNull DensityStat.BandWidthMethod bandWidthMethod, double adjust, @NotNull DensityStat.Kernel kernel2, int n, int fullScanMax, @NotNull List<Double> quantiles) {
        Intrinsics.checkNotNullParameter((Object)((Object)bandWidthMethod), (String)"bandWidthMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)kernel2), (String)"kernel");
        Intrinsics.checkNotNullParameter(quantiles, (String)"quantiles");
        super(DEF_MAPPING);
        this.trim = trim;
        this.tailsCutoff = tailsCutoff;
        this.bandWidth = bandWidth;
        this.bandWidthMethod = bandWidthMethod;
        this.adjust = adjust;
        this.kernel = kernel2;
        this.n = n;
        this.fullScanMax = fullScanMax;
        this.quantiles = quantiles;
        if (!(this.n <= 1024)) {
            boolean bl = false;
            String string = "The input n = " + this.n + " > 1024 is too large!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getWEIGHT()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        DoubleSpan doubleSpan;
        List ws;
        List list2;
        List ys;
        int n;
        ArrayList<Double> arrayList;
        int n2;
        int n3;
        List list3;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        List<Double> xs = data.getNumeric(TransformVar.INSTANCE.getX());
        if (data.has(TransformVar.INSTANCE.getY())) {
            list3 = data.getNumeric(TransformVar.INSTANCE.getY());
        } else {
            int n4 = xs.size();
            ArrayList<Double> arrayList2 = new ArrayList<Double>(n4);
            int n5 = 0;
            while (n5 < n4) {
                n2 = n3 = n5++;
                arrayList = arrayList2;
                n = 0;
                arrayList.add(0.0);
            }
            list3 = ys = (List)arrayList2;
        }
        if (data.has(TransformVar.INSTANCE.getWEIGHT())) {
            list2 = data.getNumeric(TransformVar.INSTANCE.getWEIGHT());
        } else {
            int n6 = ys.size();
            ArrayList arrayList3 = new ArrayList(n6);
            n3 = 0;
            while (n3 < n6) {
                n = n2 = n3++;
                arrayList = arrayList3;
                boolean bl = false;
                arrayList.add(1.0);
            }
            list2 = ws = (List)arrayList3;
        }
        if ((doubleSpan = statCtx.overallXRange()) == null) {
            doubleSpan = new DoubleSpan(-0.5, 0.5);
        }
        DoubleSpan overallXRange = doubleSpan;
        Map<DataFrame.Variable, List<Double>> statData = DensityStatUtil.INSTANCE.binnedStat(ys, xs, ws, this.trim, this.tailsCutoff, this.bandWidth, this.bandWidthMethod, this.adjust, this.kernel, this.n, this.fullScanMax, overallXRange, this.quantiles, Stats.INSTANCE.getY(), Stats.INSTANCE.getX());
        DataFrame.Builder builder = new DataFrame.Builder();
        for (Map.Entry<DataFrame.Variable, List<Double>> entry : statData.entrySet()) {
            DataFrame.Variable variable = entry.getKey();
            List<Double> series = entry.getValue();
            builder.putNumeric(variable, series);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame normalize(@NotNull DataFrame dataAfterStat) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)dataAfterStat, (String)"dataAfterStat");
        if (dataAfterStat.rowCount() == 0) {
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = dataAfterStat.getNumeric(Stats.INSTANCE.getDENSITY());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Double d = (Double)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNull((Object)v1);
                collection.add(v1.doubleValue());
            }
            List statDensity = (List)destination$iv$iv;
            Double d = CollectionsKt.maxOrNull((Iterable)statDensity);
            Intrinsics.checkNotNull((Object)d);
            double densityMax = d;
            Iterable $this$map$iv2 = statDensity;
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                double d2 = ((Number)item$iv$iv).doubleValue();
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add((double)(it / densityMax));
            }
            list2 = (List)destination$iv$iv2;
        }
        List statHeight = list2;
        return dataAfterStat.builder().putNumeric(Stats.INSTANCE.getHEIGHT(), statHeight).build();
    }

    static {
        Object[] objectArray = new Double[]{0.25, 0.5, 0.75};
        DEF_QUANTILES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY()), TuplesKt.to(Aes.Companion.getHEIGHT(), (Object)Stats.INSTANCE.getHEIGHT()), TuplesKt.to(Aes.Companion.getQUANTILE(), (Object)Stats.INSTANCE.getQUANTILE())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityRidgesStat$Companion;", "", "()V", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "DEF_QUANTILES", "", "", "getDEF_QUANTILES", "()Ljava/util/List;", "DEF_TRIM", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Double> getDEF_QUANTILES() {
            return DEF_QUANTILES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

