/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\u0014\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\u0014\u0010\t\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\u0014\u0010\n\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\u0014\u0010\u000b\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\u001c\u0010\f\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\r\u001a\u00020\u0004J\u0014\u0010\u000e\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/AggregateFunctions;", "", "()V", "count", "", "values", "", "max", "sortedValues", "mean", "median", "min", "quantile", "p", "sum", "plot-base"})
public final class AggregateFunctions {
    @NotNull
    public static final AggregateFunctions INSTANCE = new AggregateFunctions();

    private AggregateFunctions() {
    }

    public final double count(@NotNull List<Double> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return values.size();
    }

    public final double sum(@NotNull List<Double> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return values.size() == 0 ? Double.NaN : CollectionsKt.sumOfDouble((Iterable)values);
    }

    public final double mean(@NotNull List<Double> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return values.size() == 0 ? Double.NaN : this.sum(values) / this.count(values);
    }

    public final double median(@NotNull List<Double> sortedValues) {
        Intrinsics.checkNotNullParameter(sortedValues, (String)"sortedValues");
        return this.quantile(sortedValues, 0.5);
    }

    public final double min(@NotNull List<Double> sortedValues) {
        Intrinsics.checkNotNullParameter(sortedValues, (String)"sortedValues");
        Double d = (Double)CollectionsKt.firstOrNull(sortedValues);
        return d != null ? d : Double.NaN;
    }

    public final double max(@NotNull List<Double> sortedValues) {
        Intrinsics.checkNotNullParameter(sortedValues, (String)"sortedValues");
        Double d = (Double)CollectionsKt.lastOrNull(sortedValues);
        return d != null ? d : Double.NaN;
    }

    public final double quantile(@NotNull List<Double> sortedValues, double p) {
        Intrinsics.checkNotNullParameter(sortedValues, (String)"sortedValues");
        if (sortedValues.isEmpty()) {
            return Double.NaN;
        }
        double place = p * (double)(sortedValues.size() - 1);
        return Math.rint(place) == place ? ((Number)sortedValues.get((int)place)).doubleValue() : (((Number)sortedValues.get((int)Math.ceil(place))).doubleValue() + ((Number)sortedValues.get((int)Math.floor(place))).doubleValue()) / 2.0;
    }
}

