/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jcs;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public final class Jcs {
    protected static final DecimalFormat eFormatBigDecimal = new DecimalFormat("0E00", new DecimalFormatSymbols(Locale.ENGLISH));
    protected static final DecimalFormat eFormat = new DecimalFormat("0.#######", new DecimalFormatSymbols(Locale.ENGLISH));

    public static final String canonize(JsonValue value) {
        StringWriter writer = new StringWriter();
        try {
            Jcs.canonize(value, writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static final void canonize(JsonValue value, Writer writer) throws IOException {
        JsonValue.ValueType valueType;
        JsonValue.ValueType valueType2 = valueType = value != null ? value.getValueType() : null;
        if (valueType == null || JsonValue.ValueType.NULL == valueType) {
            writer.write("null");
            return;
        }
        switch (valueType) {
            case ARRAY: {
                Jcs.canonizeArray(value.asJsonArray(), writer);
                break;
            }
            case OBJECT: {
                Jcs.canonizeObject(value.asJsonObject(), writer);
                break;
            }
            case NUMBER: {
                writer.write(Jcs.canonizeNumber((JsonNumber)value));
                break;
            }
            case FALSE: 
            case TRUE: 
            case STRING: 
            case NULL: {
                writer.write(value.toString());
            }
        }
    }

    public static final String canonizeNumber(JsonNumber number) {
        if (number.bigDecimalValue().compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        if (number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointRight(21)) >= 0) {
            return eFormatBigDecimal.format(number.bigDecimalValue()).replace("E", "e+");
        }
        if (number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointLeft(21)) <= 0) {
            return eFormatBigDecimal.format(number.bigDecimalValue()).toLowerCase();
        }
        return eFormat.format(number.bigDecimalValue());
    }

    public static final void canonizeArray(JsonArray value, Writer writer) throws IOException {
        boolean next = false;
        writer.write("[");
        for (JsonValue item : value.asJsonArray()) {
            if (next) {
                writer.write(",");
            }
            Jcs.canonize(item, writer);
            next = true;
        }
        writer.write("]");
    }

    public static final void canonizeObject(JsonObject value, Writer writer) throws IOException {
        boolean next = false;
        writer.write("{");
        Set properties = value.keySet();
        if (properties != null && !properties.isEmpty()) {
            ArrayList sortedProperties = new ArrayList(properties);
            Collections.sort(sortedProperties);
            for (String propertyName : sortedProperties) {
                if (next) {
                    writer.write(",");
                }
                writer.write("\"");
                writer.write(Jcs.escape(propertyName));
                writer.write("\":");
                JsonValue propertyValue = (JsonValue)value.get((Object)propertyName);
                Jcs.canonize(propertyValue, writer);
                next = true;
            }
        }
        writer.write("}");
    }

    public static final String escape(String value) {
        int[] codePoints;
        StringBuilder escaped = new StringBuilder();
        for (int ch : codePoints = value.codePoints().toArray()) {
            if (ch == 9) {
                escaped.append("\\t");
                continue;
            }
            if (ch == 8) {
                escaped.append("\\b");
                continue;
            }
            if (ch == 10) {
                escaped.append("\\n");
                continue;
            }
            if (ch == 13) {
                escaped.append("\\r");
                continue;
            }
            if (ch == 12) {
                escaped.append("\\f");
                continue;
            }
            if (ch == 34) {
                escaped.append("\\\"");
                continue;
            }
            if (ch == 92) {
                escaped.append("\\\\");
                continue;
            }
            if (ch >= 0 && ch <= 31 || ch == 127) {
                escaped.append(String.format("\\u%04x", ch));
                continue;
            }
            escaped.appendCodePoint(ch);
        }
        return escaped.toString();
    }

    public static final boolean equals(JsonValue value1, JsonValue value2) {
        if (value1 == null) {
            return value2 == null || value2.getValueType() == JsonValue.ValueType.NULL;
        }
        if (value2 == null) {
            return value1.getValueType() == JsonValue.ValueType.NULL;
        }
        if (value1.getValueType() != value2.getValueType()) {
            return false;
        }
        switch (value1.getValueType()) {
            case FALSE: 
            case TRUE: 
            case NULL: {
                return true;
            }
            case STRING: {
                return value1.equals(value2);
            }
            case NUMBER: {
                return Jcs.numberEquals((JsonNumber)value1, (JsonNumber)value2);
            }
            case ARRAY: {
                return Jcs.arrayEquals(value1.asJsonArray(), value2.asJsonArray());
            }
            case OBJECT: {
                return Jcs.objectEquals(value1.asJsonObject(), value2.asJsonObject());
            }
        }
        return false;
    }

    public static final boolean numberEquals(JsonNumber number1, JsonNumber number2) {
        return Jcs.canonizeNumber(number1).equals(Jcs.canonizeNumber(number2));
    }

    public static final boolean objectEquals(JsonObject object1, JsonObject object2) {
        if (object1.size() != object2.size()) {
            return false;
        }
        if (object1.isEmpty()) {
            return true;
        }
        List keys1 = object1.keySet().stream().sorted().collect(Collectors.toList());
        List keys2 = object2.keySet().stream().sorted().collect(Collectors.toList());
        for (int index = 0; index < keys1.size(); ++index) {
            String k1 = (String)keys1.get(index);
            String k2 = (String)keys2.get(index);
            if (Jcs.escape(k1).equals(Jcs.escape(k2)) && Jcs.equals((JsonValue)object1.get((Object)k1), (JsonValue)object2.get((Object)k2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayEquals(JsonArray array1, JsonArray array2) {
        if (array1.size() != array2.size()) {
            return false;
        }
        if (array1.isEmpty()) {
            return true;
        }
        for (int index = 0; index < array1.size(); ++index) {
            if (Jcs.equals((JsonValue)array1.get(index), (JsonValue)array2.get(index))) continue;
            return false;
        }
        return true;
    }
}

