/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet.filter;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.mailet.filter.JMAPFiltering;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.AuditTrail;
import org.apache.mailet.Attribute;
import org.apache.mailet.LoopPrevention;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.StorageDirective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionApplier {
    public static final Logger LOGGER = LoggerFactory.getLogger(ActionApplier.class);
    private final MailboxManager mailboxManager;
    private final MailboxId.Factory mailboxIdFactory;
    private final MailetContext mailetContext;
    private final Mail mail;
    private final MailAddress mailAddress;
    private final Username username;

    @VisibleForTesting
    public static Factory factory(MailboxManager mailboxManager, MailboxId.Factory mailboxIdFactory) {
        return new Factory(mailboxManager, mailboxIdFactory);
    }

    private ActionApplier(MailboxManager mailboxManager, MailboxId.Factory mailboxIdFactory, MailetContext mailetContext, Mail mail, MailAddress mailAddress, Username username) {
        this.mailboxManager = mailboxManager;
        this.mailboxIdFactory = mailboxIdFactory;
        this.mailetContext = mailetContext;
        this.mail = mail;
        this.mailAddress = mailAddress;
        this.username = username;
    }

    public void apply(Stream<Rule.Action> actions) {
        actions.forEach(this::applyAction);
    }

    private boolean shouldProcessingContinue() {
        return this.mail.getRecipients().contains(this.mailAddress);
    }

    private void applyAction(Rule.Action action) {
        this.applyReject(action);
        this.applyForward(action);
        this.applyStorageDirective(action);
    }

    private void applyReject(Rule.Action action) {
        if (action.isReject()) {
            this.removeFromRecipients();
        }
    }

    private void applyForward(Rule.Action action) {
        action.getForward().filter(any -> this.shouldProcessingContinue()).ifPresent((Consumer<Rule.Action.Forward>)Throwing.consumer(forward -> {
            boolean emailIsDropped;
            boolean localCopy;
            LoopPrevention.RecordedRecipients recordedRecipients = LoopPrevention.RecordedRecipients.fromMail((Mail)this.mail);
            if (recordedRecipients.getRecipients().contains(this.mailAddress)) {
                return;
            }
            Set<MailAddress> newRecipients = this.getNewRecipients((Rule.Action.Forward)forward, recordedRecipients);
            Sets.SetView forwardRecipients = Sets.difference(newRecipients, (Set)ImmutableSet.of((Object)this.mailAddress));
            if (!forwardRecipients.isEmpty()) {
                this.sendACopy(recordedRecipients, (Set<MailAddress>)forwardRecipients);
            }
            if (!(localCopy = newRecipients.contains(this.mailAddress))) {
                this.removeFromRecipients();
            }
            boolean bl = emailIsDropped = !forward.getAddresses().isEmpty() && forwardRecipients.isEmpty() && !localCopy;
            if (emailIsDropped) {
                this.recordLoop();
            }
        }));
    }

    private Set<MailAddress> getNewRecipients(Rule.Action.Forward forward, LoopPrevention.RecordedRecipients recordedRecipients) {
        ImmutableSet.Builder newRecipientsBuilder = ImmutableSet.builder().addAll((Iterable)recordedRecipients.nonRecordedRecipients((Collection)forward.getAddresses()));
        if (forward.isKeepACopy()) {
            newRecipientsBuilder.add((Object)this.mailAddress);
        }
        return newRecipientsBuilder.build();
    }

    private void removeFromRecipients() {
        AuditTrail.entry().action("REJECT").username(() -> ((MailAddress)this.mailAddress).asString()).sessionId(() -> ((Mail)this.mail).getName()).log("Dropping email for the user as he rejected the mail.");
        this.mail.setRecipients((Collection)this.mail.getRecipients().stream().filter(recipient -> !recipient.equals((Object)this.mailAddress)).collect(ImmutableList.toImmutableList()));
    }

    private void applyStorageDirective(Rule.Action action) {
        if (this.shouldProcessingContinue()) {
            Optional<ImmutableList<String>> targetMailboxes = this.computeTargetMailboxes(action);
            StorageDirective.Builder storageDirective = StorageDirective.builder();
            targetMailboxes.ifPresent(arg_0 -> ((StorageDirective.Builder)storageDirective).targetFolders(arg_0));
            storageDirective.seen(Optional.of(action.isMarkAsSeen()).filter(seen -> seen)).important(Optional.of(action.isMarkAsImportant()).filter(seen -> seen)).keywords(Optional.of(action.getWithKeywords()).filter(c -> !c.isEmpty())).buildOptional().map(a -> a.encodeAsAttributes(this.username)).orElse(Stream.of(new Attribute[0])).forEach(arg_0 -> ((Mail)this.mail).setAttribute(arg_0));
        }
    }

    private Optional<ImmutableList<String>> computeTargetMailboxes(Rule.Action action) {
        return Optional.of((ImmutableList)action.getAppendInMailboxes().getMailboxIds().stream().flatMap(this::asMailboxName).collect(ImmutableList.toImmutableList())).filter(mailboxes -> !mailboxes.isEmpty());
    }

    private Stream<String> asMailboxName(String mailboxIdString) {
        try {
            MailboxId mailboxId = this.mailboxIdFactory.fromString(mailboxIdString);
            MailboxSession mailboxSession = this.mailboxManager.createSystemSession(this.username);
            MessageManager messageManager = this.mailboxManager.getMailbox(mailboxId, mailboxSession);
            this.mailboxManager.endProcessingRequest(mailboxSession);
            return Stream.of(messageManager.getMailboxPath().getName());
        }
        catch (MailboxNotFoundException e) {
            LOGGER.info("Mailbox {} does not exist, but it was mentioned in a JMAP filtering rule", (Object)mailboxIdString, (Object)e);
            return Stream.empty();
        }
        catch (Exception e) {
            LOGGER.error("Unexpected failure while resolving mailbox name for {}", (Object)mailboxIdString, (Object)e);
            return Stream.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendACopy(LoopPrevention.RecordedRecipients recordedRecipients, Set<MailAddress> newRecipients) throws MessagingException {
        MailImpl copy = MailImpl.duplicate((Mail)this.mail);
        try {
            copy.setSender(this.mailAddress);
            copy.setRecipients(newRecipients);
            recordedRecipients.merge(new MailAddress[]{this.mailAddress}).recordOn((Mail)copy);
            this.mailetContext.sendMail((Mail)copy);
            this.recordInAuditTrail(copy);
        }
        finally {
            LifecycleUtil.dispose((Object)copy);
        }
    }

    private void recordLoop() throws MessagingException {
        MailImpl copy = MailImpl.duplicate((Mail)this.mail);
        try {
            copy.setRecipients((Collection)ImmutableList.of((Object)this.mailAddress));
            copy.setState(JMAPFiltering.RRT_ERROR.getValue());
            this.mailetContext.sendMail((Mail)copy);
        }
        finally {
            LifecycleUtil.dispose((Object)copy);
        }
    }

    private void recordInAuditTrail(MailImpl copy) {
        AuditTrail.entry().protocol("mailetcontainer").action("JMAPFiltering").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"mailId", (Object)this.mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(this.mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"sender", (Object)this.mail.getMaybeSender().asString(), (Object)"forwardedMailId", (Object)copy.getName(), (Object)"forwardedMailSender", (Object)copy.getMaybeSender().asString(), (Object)"forwardedMailRecipient", (Object)StringUtils.join((Object[])new Collection[]{copy.getRecipients()})))).log("Mail forwarded.");
    }

    @VisibleForTesting
    static class Factory {
        private final MailboxManager mailboxManager;
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        Factory(MailboxManager mailboxManager, MailboxId.Factory mailboxIdFactory) {
            this.mailboxManager = mailboxManager;
            this.mailboxIdFactory = mailboxIdFactory;
        }

        public RequireUser forMail(Mail mail) {
            return new RequireUser(mail);
        }

        public class RequireUser {
            private final Mail mail;

            RequireUser(Mail mail) {
                this.mail = mail;
            }

            public ActionApplier forRecipient(MailetContext mailetContext, MailAddress mailAddress, Username username) {
                return new ActionApplier(Factory.this.mailboxManager, Factory.this.mailboxIdFactory, mailetContext, this.mail, mailAddress, username);
            }
        }
    }
}

