/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.SearchEntryTransformer;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AccessLogRequestHandler
extends LDAPListenerRequestHandler
implements SearchEntryTransformer {
    @Nullable
    private final AtomicLong nextOperationID;
    @NotNull
    private final ConcurrentHashMap<Integer, AtomicLong> entryCounts = new ConcurrentHashMap(StaticUtils.computeMapCapacity(50));
    @NotNull
    private final Handler logHandler;
    @Nullable
    private final LDAPListenerClientConnection clientConnection;
    @NotNull
    private final LDAPListenerRequestHandler requestHandler;
    @NotNull
    private final ThreadLocal<DecimalFormat> decimalFormatters;
    @NotNull
    private final ThreadLocal<SimpleDateFormat> timestampFormatters;
    @NotNull
    private final ThreadLocal<StringBuilder> buffers;

    public AccessLogRequestHandler(@NotNull Handler logHandler, @NotNull LDAPListenerRequestHandler requestHandler) {
        Validator.ensureNotNull(logHandler, requestHandler);
        this.logHandler = logHandler;
        this.requestHandler = requestHandler;
        this.decimalFormatters = new ThreadLocal();
        this.timestampFormatters = new ThreadLocal();
        this.buffers = new ThreadLocal();
        this.nextOperationID = null;
        this.clientConnection = null;
    }

    private AccessLogRequestHandler(@NotNull Handler logHandler, @NotNull LDAPListenerRequestHandler requestHandler, @NotNull LDAPListenerClientConnection clientConnection, @NotNull ThreadLocal<StringBuilder> buffers, @NotNull ThreadLocal<SimpleDateFormat> timestampFormatters, @NotNull ThreadLocal<DecimalFormat> decimalFormatters) {
        this.logHandler = logHandler;
        this.requestHandler = requestHandler;
        this.clientConnection = clientConnection;
        this.buffers = buffers;
        this.timestampFormatters = timestampFormatters;
        this.decimalFormatters = decimalFormatters;
        this.nextOperationID = new AtomicLong(0L);
    }

    @Override
    @NotNull
    public AccessLogRequestHandler newInstance(@NotNull LDAPListenerClientConnection connection) throws LDAPException {
        AccessLogRequestHandler h = new AccessLogRequestHandler(this.logHandler, this.requestHandler.newInstance(connection), connection, this.buffers, this.timestampFormatters, this.decimalFormatters);
        connection.addSearchEntryTransformer(h);
        StringBuilder b = h.getConnectionHeader("CONNECT");
        Socket s = connection.getSocket();
        b.append(" from=\"");
        b.append(s.getInetAddress().getHostAddress());
        b.append(':');
        b.append(s.getPort());
        b.append("\" to=\"");
        b.append(s.getLocalAddress().getHostAddress());
        b.append(':');
        b.append(s.getLocalPort());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return h;
    }

    @Override
    public void closeInstance() {
        StringBuilder b = this.getConnectionHeader("DISCONNECT");
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        this.requestHandler.closeInstance();
    }

    @Override
    public void processAbandonRequest(int messageID, @NotNull AbandonRequestProtocolOp request, @NotNull List<Control> controls) {
        StringBuilder b = this.getRequestHeader("ABANDON", this.nextOperationID.getAndIncrement(), messageID);
        b.append(" idToAbandon=");
        b.append(request.getIDToAbandon());
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        this.requestHandler.processAbandonRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processAddRequest(int messageID, @NotNull AddRequestProtocolOp request, @NotNull List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("ADD", opID, messageID);
        b.append(" dn=\"");
        b.append(request.getDN());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processAddRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        AddResponseProtocolOp protocolOp = responseMessage.getAddResponseProtocolOp();
        this.generateResponse(b, "ADD", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    @NotNull
    public LDAPMessage processBindRequest(int messageID, @NotNull BindRequestProtocolOp request, @NotNull List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("BIND", opID, messageID);
        b.append(" version=");
        b.append(request.getVersion());
        b.append(" dn=\"");
        b.append(request.getBindDN());
        b.append("\" authType=\"");
        switch (request.getCredentialsType()) {
            case -128: {
                b.append("SIMPLE");
                break;
            }
            case -93: {
                b.append("SASL ");
                b.append(request.getSASLMechanism());
            }
        }
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processBindRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        BindResponseProtocolOp protocolOp = responseMessage.getBindResponseProtocolOp();
        this.generateResponse(b, "BIND", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    @NotNull
    public LDAPMessage processCompareRequest(int messageID, @NotNull CompareRequestProtocolOp request, @NotNull List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("COMPARE", opID, messageID);
        b.append(" dn=\"");
        b.append(request.getDN());
        b.append("\" attr=\"");
        b.append(request.getAttributeName());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processCompareRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        CompareResponseProtocolOp protocolOp = responseMessage.getCompareResponseProtocolOp();
        this.generateResponse(b, "COMPARE", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    @NotNull
    public LDAPMessage processDeleteRequest(int messageID, @NotNull DeleteRequestProtocolOp request, @NotNull List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("DELETE", opID, messageID);
        b.append(" dn=\"");
        b.append(request.getDN());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processDeleteRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        DeleteResponseProtocolOp protocolOp = responseMessage.getDeleteResponseProtocolOp();
        this.generateResponse(b, "DELETE", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    @NotNull
    public LDAPMessage processExtendedRequest(int messageID, @NotNull ExtendedRequestProtocolOp request, @NotNull List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("EXTENDED", opID, messageID);
        b.append(" requestOID=\"");
        b.append(request.getOID());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processExtendedRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        ExtendedResponseProtocolOp protocolOp = responseMessage.getExtendedResponseProtocolOp();
        this.generateResponse(b, "EXTENDED", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        String responseOID = protocolOp.getResponseOID();
        if (responseOID != null) {
            b.append(" responseOID=\"");
            b.append(responseOID);
            b.append('\"');
        }
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    @NotNull
    public LDAPMessage processModifyRequest(int messageID, @NotNull ModifyRequestProtocolOp request, @NotNull List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("MODIFY", opID, messageID);
        b.append(" dn=\"");
        b.append(request.getDN());
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processModifyRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        ModifyResponseProtocolOp protocolOp = responseMessage.getModifyResponseProtocolOp();
        this.generateResponse(b, "MODIFY", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    @Override
    @NotNull
    public LDAPMessage processModifyDNRequest(int messageID, @NotNull ModifyDNRequestProtocolOp request, @NotNull List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("MODDN", opID, messageID);
        b.append(" dn=\"");
        b.append(request.getDN());
        b.append("\" newRDN=\"");
        b.append(request.getNewRDN());
        b.append("\" deleteOldRDN=");
        b.append(request.deleteOldRDN());
        String newSuperior = request.getNewSuperiorDN();
        if (newSuperior != null) {
            b.append(" newSuperior=\"");
            b.append(newSuperior);
            b.append('\"');
        }
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        long startTimeNanos = System.nanoTime();
        LDAPMessage responseMessage = this.requestHandler.processModifyDNRequest(messageID, request, controls);
        long eTimeNanos = System.nanoTime() - startTimeNanos;
        ModifyDNResponseProtocolOp protocolOp = responseMessage.getModifyDNResponseProtocolOp();
        this.generateResponse(b, "MODDN", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LDAPMessage processSearchRequest(int messageID, @NotNull SearchRequestProtocolOp request, @NotNull List<Control> controls) {
        long opID = this.nextOperationID.getAndIncrement();
        StringBuilder b = this.getRequestHeader("SEARCH", opID, messageID);
        b.append(" base=\"");
        b.append(request.getBaseDN());
        b.append("\" scope=");
        b.append(request.getScope().intValue());
        b.append(" filter=\"");
        request.getFilter().toString(b);
        b.append("\" attrs=\"");
        List<String> attrList = request.getAttributes();
        if (attrList.isEmpty()) {
            b.append("ALL");
        } else {
            Iterator<String> iterator = attrList.iterator();
            while (iterator.hasNext()) {
                b.append(iterator.next());
                if (!iterator.hasNext()) continue;
                b.append(',');
            }
        }
        b.append('\"');
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        AtomicLong l = new AtomicLong(0L);
        this.entryCounts.put(messageID, l);
        try {
            long startTimeNanos = System.nanoTime();
            LDAPMessage responseMessage = this.requestHandler.processSearchRequest(messageID, request, controls);
            long eTimeNanos = System.nanoTime() - startTimeNanos;
            SearchResultDoneProtocolOp protocolOp = responseMessage.getSearchResultDoneProtocolOp();
            this.generateResponse(b, "SEARCH", opID, messageID, protocolOp.getResultCode(), protocolOp.getDiagnosticMessage(), protocolOp.getMatchedDN(), protocolOp.getReferralURLs(), eTimeNanos);
            b.append(" entriesReturned=");
            b.append(l.get());
            this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
            this.logHandler.flush();
            LDAPMessage lDAPMessage = responseMessage;
            return lDAPMessage;
        }
        finally {
            this.entryCounts.remove(messageID);
        }
    }

    @Override
    public void processUnbindRequest(int messageID, @NotNull UnbindRequestProtocolOp request, @NotNull List<Control> controls) {
        StringBuilder b = this.getRequestHeader("UNBIND", this.nextOperationID.getAndIncrement(), messageID);
        this.logHandler.publish(new LogRecord(Level.INFO, b.toString()));
        this.logHandler.flush();
        this.requestHandler.processUnbindRequest(messageID, request, controls);
    }

    @NotNull
    private StringBuilder getBuffer() {
        StringBuilder b = this.buffers.get();
        if (b == null) {
            b = new StringBuilder();
            this.buffers.set(b);
        } else {
            b.setLength(0);
        }
        return b;
    }

    private void addTimestamp(@NotNull StringBuilder buffer) {
        SimpleDateFormat dateFormat = this.timestampFormatters.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("'['dd/MMM/yyyy:HH:mm:ss Z']'");
            this.timestampFormatters.set(dateFormat);
        }
        buffer.append(dateFormat.format(new Date()));
    }

    @NotNull
    private StringBuilder getConnectionHeader(@NotNull String messageType) {
        StringBuilder b = this.getBuffer();
        this.addTimestamp(b);
        b.append(' ');
        b.append(messageType);
        b.append(" conn=");
        b.append(this.clientConnection.getConnectionID());
        return b;
    }

    @NotNull
    private StringBuilder getRequestHeader(@NotNull String opType, long opID, int msgID) {
        StringBuilder b = this.getBuffer();
        this.addTimestamp(b);
        b.append(' ');
        b.append(opType);
        b.append(" REQUEST conn=");
        b.append(this.clientConnection.getConnectionID());
        b.append(" op=");
        b.append(opID);
        b.append(" msgID=");
        b.append(msgID);
        return b;
    }

    private void generateResponse(@NotNull StringBuilder b, @NotNull String opType, long opID, int msgID, int resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @NotNull List<String> referralURLs, long eTimeNanos) {
        DecimalFormat f;
        b.setLength(0);
        this.addTimestamp(b);
        b.append(' ');
        b.append(opType);
        b.append(" RESULT conn=");
        b.append(this.clientConnection.getConnectionID());
        b.append(" op=");
        b.append(opID);
        b.append(" msgID=");
        b.append(msgID);
        b.append(" resultCode=");
        b.append(resultCode);
        if (diagnosticMessage != null) {
            b.append(" diagnosticMessage=\"");
            b.append(diagnosticMessage);
            b.append('\"');
        }
        if (matchedDN != null) {
            b.append(" matchedDN=\"");
            b.append(matchedDN);
            b.append('\"');
        }
        if (!referralURLs.isEmpty()) {
            b.append(" referralURLs=\"");
            Iterator<String> iterator = referralURLs.iterator();
            while (iterator.hasNext()) {
                b.append(iterator.next());
                if (!iterator.hasNext()) continue;
                b.append(',');
            }
            b.append('\"');
        }
        if ((f = this.decimalFormatters.get()) == null) {
            f = new DecimalFormat("0.000");
            this.decimalFormatters.set(f);
        }
        b.append(" etime=");
        b.append(f.format((double)eTimeNanos / 1000000.0));
    }

    @Override
    @NotNull
    public ObjectPair<SearchResultEntryProtocolOp, Control[]> transformEntry(int messageID, @NotNull SearchResultEntryProtocolOp entry, @NotNull Control[] controls) {
        AtomicLong l = this.entryCounts.get(messageID);
        if (l != null) {
            l.incrementAndGet();
        }
        return new ObjectPair<SearchResultEntryProtocolOp, Control[]>(entry, controls);
    }
}

