/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.core.get_script_languages.LanguageContext;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class GetScriptLanguagesResponse
implements JsonpSerializable {
    private final List<LanguageContext> languageContexts;
    private final List<String> typesAllowed;
    public static final JsonpDeserializer<GetScriptLanguagesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetScriptLanguagesResponse::setupGetScriptLanguagesResponseDeserializer);

    private GetScriptLanguagesResponse(Builder builder) {
        this.languageContexts = ApiTypeHelper.unmodifiableRequired(builder.languageContexts, (Object)this, "languageContexts");
        this.typesAllowed = ApiTypeHelper.unmodifiableRequired(builder.typesAllowed, (Object)this, "typesAllowed");
    }

    public static GetScriptLanguagesResponse of(Function<Builder, ObjectBuilder<GetScriptLanguagesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<LanguageContext> languageContexts() {
        return this.languageContexts;
    }

    public final List<String> typesAllowed() {
        return this.typesAllowed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.languageContexts)) {
            generator.writeKey("language_contexts");
            generator.writeStartArray();
            for (LanguageContext languageContext : this.languageContexts) {
                languageContext.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.typesAllowed)) {
            generator.writeKey("types_allowed");
            generator.writeStartArray();
            for (String string : this.typesAllowed) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGetScriptLanguagesResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::languageContexts, JsonpDeserializer.arrayDeserializer(LanguageContext._DESERIALIZER), "language_contexts");
        op.add(Builder::typesAllowed, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "types_allowed");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetScriptLanguagesResponse> {
        private List<LanguageContext> languageContexts;
        private List<String> typesAllowed;

        public final Builder languageContexts(List<LanguageContext> list) {
            this.languageContexts = Builder._listAddAll(this.languageContexts, list);
            return this;
        }

        public final Builder languageContexts(LanguageContext value, LanguageContext ... values) {
            this.languageContexts = Builder._listAdd(this.languageContexts, value, values);
            return this;
        }

        public final Builder languageContexts(Function<LanguageContext.Builder, ObjectBuilder<LanguageContext>> fn) {
            return this.languageContexts(fn.apply(new LanguageContext.Builder()).build(), new LanguageContext[0]);
        }

        public final Builder typesAllowed(List<String> list) {
            this.typesAllowed = Builder._listAddAll(this.typesAllowed, list);
            return this;
        }

        public final Builder typesAllowed(String value, String ... values) {
            this.typesAllowed = Builder._listAdd(this.typesAllowed, value, values);
            return this;
        }

        @Override
        public GetScriptLanguagesResponse build() {
            this._checkSingleUse();
            return new GetScriptLanguagesResponse(this);
        }
    }
}

