/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.utils;

import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockLessConcurrencyLimitingRequestThrottler
implements RequestThrottler {
    private static final Logger LOG = LoggerFactory.getLogger(LockLessConcurrencyLimitingRequestThrottler.class);
    private final String logPrefix;
    private final int maxConcurrentRequests;
    private final int maxQueueSize;
    private final AtomicInteger concurrentRequests = new AtomicInteger(0);
    private final Queue<Throttled> queue = new ConcurrentLinkedQueue<Throttled>();
    private boolean closed;

    public LockLessConcurrencyLimitingRequestThrottler(DriverContext context) {
        this.logPrefix = context.getSessionName();
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        this.maxConcurrentRequests = config.getInt((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_CONCURRENT_REQUESTS);
        this.maxQueueSize = config.getInt((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_QUEUE_SIZE);
        LOG.debug("[{}] Initializing with maxConcurrentRequests = {}, maxQueueSize = {}", new Object[]{this.logPrefix, this.maxConcurrentRequests, this.maxQueueSize});
    }

    public void register(Throttled request) {
        int requestNumber = this.concurrentRequests.incrementAndGet();
        if (this.closed) {
            LockLessConcurrencyLimitingRequestThrottler.fail(request, "The session is shutting down");
        } else if (requestNumber < this.maxConcurrentRequests) {
            request.onThrottleReady(false);
        } else if (requestNumber < this.maxQueueSize + this.maxConcurrentRequests) {
            this.queue.add(request);
        } else {
            this.concurrentRequests.decrementAndGet();
            LockLessConcurrencyLimitingRequestThrottler.fail(request, String.format("The session has reached its maximum capacity (concurrent requests: %d, queue size: %d)", this.maxConcurrentRequests, this.maxQueueSize));
        }
    }

    public void signalSuccess(Throttled request) {
        this.onRequestDone();
    }

    public void signalError(Throttled request, Throwable error) {
        this.signalSuccess(request);
    }

    public void signalTimeout(Throttled request) {
        if (!this.closed) {
            if (this.queue.remove(request)) {
                this.concurrentRequests.decrementAndGet();
            } else {
                this.onRequestDone();
            }
        }
    }

    private void onRequestDone() {
        if (!this.closed) {
            this.concurrentRequests.decrementAndGet();
            Throttled throttled = this.queue.poll();
            if (throttled != null) {
                throttled.onThrottleReady(true);
            }
        }
    }

    public void close() {
        this.closed = true;
        LOG.debug("[{}] Rejecting {} queued requests after shutdown", (Object)this.logPrefix, (Object)this.queue.size());
        for (Throttled request : this.queue) {
            LockLessConcurrencyLimitingRequestThrottler.fail(request, "The session is shutting down");
        }
    }

    public int getQueueSize() {
        return Math.max(0, this.concurrentRequests.get() - this.maxConcurrentRequests);
    }

    private static void fail(Throttled request, String message) {
        request.onThrottleFailure(new RequestThrottlingException(message));
    }
}

