/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Suppliers;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class MemoizedSupplier<T>
implements Supplier<T> {
    private final Supplier<T> memorizeSupplier = Suppliers.memoize(originalSupplier::get);
    private final AtomicReference<T> valueReference = new AtomicReference();

    public static <T> MemoizedSupplier<T> of(Supplier<T> originalSupplier) {
        return new MemoizedSupplier<T>(originalSupplier);
    }

    public MemoizedSupplier(Supplier<T> originalSupplier) {
    }

    public void ifInitialized(Consumer<T> valueConsumer) {
        T value = this.valueReference.get();
        if (value != null) {
            valueConsumer.accept(value);
        }
    }

    @Override
    public T get() {
        return this.valueReference.updateAndGet(originalValue -> this.memorizeSupplier.get());
    }
}

