/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.cassandra.cache;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.cassandra.BlobTables;
import org.apache.james.blob.cassandra.cache.BlobStoreCache;
import org.apache.james.blob.cassandra.cache.CassandraCacheConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CassandraBlobStoreCache
implements BlobStoreCache {
    public static final Logger LOGGER = LoggerFactory.getLogger(CassandraBlobStoreCache.class);
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement deleteStatement;
    private final int timeToLive;
    private final DriverExecutionProfile cachingProfile;

    @Inject
    @VisibleForTesting
    CassandraBlobStoreCache(@Named(value="cache") CqlSession session, CassandraCacheConfiguration cacheConfiguration) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.timeToLive = Math.toIntExact(cacheConfiguration.getTtl().getSeconds());
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)"blob_cache").value(BlobTables.BucketBlobTable.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.ID)).value(BlobTables.BlobStoreCache.DATA, (Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BlobStoreCache.DATA)).usingTtl(QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BlobStoreCache.TTL_FOR_ROW)).build());
        this.selectStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"blob_cache").column(BlobTables.BlobStoreCache.DATA).whereColumn(BlobTables.BucketBlobTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.ID))).build());
        this.deleteStatement = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"blob_cache").whereColumn(BlobTables.BucketBlobTable.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)BlobTables.BucketBlobTable.ID))).build());
        this.cachingProfile = JamesExecutionProfiles.getCachingProfile((CqlSession)session);
    }

    public Mono<Void> cache(BlobId blobId, byte[] bytes) {
        return this.save(blobId, this.toByteBuffer(bytes));
    }

    public Mono<byte[]> read(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeSingleRow(((BoundStatement)this.selectStatement.bind(new Object[0]).setString(BlobTables.BucketBlobTable.ID, blobId.asString())).setExecutionProfile(this.cachingProfile)).map(this::toByteArray).onErrorResume(e -> {
            LOGGER.warn("Fail reading blob store cache", e);
            return Mono.empty();
        });
    }

    public Mono<Void> remove(BlobId blobId) {
        return this.cassandraAsyncExecutor.executeVoid(((BoundStatement)this.deleteStatement.bind(new Object[0]).setString(BlobTables.BucketBlobTable.ID, blobId.asString())).setExecutionProfile(this.cachingProfile));
    }

    private Mono<Void> save(BlobId blobId, ByteBuffer data) {
        return this.cassandraAsyncExecutor.executeVoid(((BoundStatement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setString(BlobTables.BucketBlobTable.ID, blobId.asString())).setByteBuffer(BlobTables.BlobStoreCache.DATA, data)).setInt(BlobTables.BlobStoreCache.TTL_FOR_ROW, this.timeToLive)).setExecutionProfile(this.cachingProfile)).onErrorResume(e -> {
            LOGGER.warn("Failed saving {} in blob store cache", (Object)blobId, e);
            return Mono.empty();
        });
    }

    private ByteBuffer toByteBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes, 0, bytes.length);
    }

    private byte[] toByteArray(Row row) {
        ByteBuffer byteBuffer = (ByteBuffer)row.get(0, TypeCodecs.BLOB);
        assert (byteBuffer != null);
        byte[] data = new byte[byteBuffer.remaining()];
        byteBuffer.get(data);
        return data;
    }
}

