/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.james.transport.mailets.ICal4JConfigurator;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICALToHeader
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ICALToHeader.class);
    private static final Class<Map<String, AttributeValue<?>>> MAP_STRING_CALENDAR = Map.class;
    public static final String ATTRIBUTE_PROPERTY = "attribute";
    public static final String ATTRIBUTE_DEFAULT_NAME = "icalendar";
    public static final AttributeName ATTRIBUTE_DEFAULT = AttributeName.of((String)"icalendar");
    public static final String X_MEETING_UID_HEADER = "X-MEETING-UID";
    public static final String X_MEETING_METHOD_HEADER = "X-MEETING-METHOD";
    public static final String X_MEETING_RECURRENCE_ID_HEADER = "X-MEETING-RECURRENCE-ID";
    public static final String X_MEETING_SEQUENCE_HEADER = "X-MEETING-SEQUENCE";
    public static final String X_MEETING_DTSTAMP_HEADER = "X-MEETING-DTSTAMP";
    private AttributeName attribute;

    public String getMailetInfo() {
        return "ICALToHeader Mailet";
    }

    public void init() throws MessagingException {
        String attributeRaw = this.getInitParameter(ATTRIBUTE_PROPERTY, ATTRIBUTE_DEFAULT_NAME);
        if (Strings.isNullOrEmpty((String)attributeRaw)) {
            throw new MessagingException("Attribute " + attributeRaw + " can not be empty or null");
        }
        this.attribute = AttributeName.of((String)attributeRaw);
    }

    public void service(Mail mail) throws MessagingException {
        try {
            AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)this.attribute, MAP_STRING_CALENDAR).ifPresent(calendarMap -> this.processCalendars((Map<String, AttributeValue<?>>)calendarMap, mail));
        }
        catch (ClassCastException e) {
            LOGGER.error("Received a mail with {} not being an ICAL object for mail {}", new Object[]{this.attribute, mail.getName(), e});
        }
    }

    private void processCalendars(Map<String, AttributeValue<?>> calendarMap, Mail mail) {
        calendarMap.values().stream().findAny().map(AttributeValue::getValue).filter(Calendar.class::isInstance).map(Calendar.class::cast).ifPresent(Throwing.consumer(calendar -> this.writeToHeaders((Calendar)calendar, mail)).sneakyThrow());
    }

    @VisibleForTesting
    AttributeName getAttribute() {
        return this.attribute;
    }

    private void writeToHeaders(Calendar calendar, Mail mail) throws MessagingException {
        MimeMessage mimeMessage = mail.getMessage();
        VEvent vevent = (VEvent)calendar.getComponent("VEVENT");
        this.addIfPresent(mimeMessage, X_MEETING_METHOD_HEADER, (Property)calendar.getMethod());
        this.addIfPresent(mimeMessage, X_MEETING_UID_HEADER, (Property)vevent.getUid());
        this.addIfPresent(mimeMessage, X_MEETING_RECURRENCE_ID_HEADER, (Property)vevent.getRecurrenceId());
        this.addIfPresent(mimeMessage, X_MEETING_SEQUENCE_HEADER, (Property)vevent.getSequence());
        this.addIfPresent(mimeMessage, X_MEETING_DTSTAMP_HEADER, (Property)vevent.getDateStamp());
    }

    private void addIfPresent(MimeMessage mimeMessage, String headerName, Property property) {
        if (property != null) {
            try {
                mimeMessage.addHeader(headerName, property.getValue());
            }
            catch (MessagingException e) {
                LOGGER.error("Could not add header {} with value {}", new Object[]{headerName, property.getValue(), e});
            }
        }
    }

    static {
        ICal4JConfigurator.configure();
    }
}

