/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.james.mailbox.model.SearchQuery;

public class SortConverter {
    private static final String SEPARATOR = " ";
    private static final String DESC_ORDERING = "desc";
    private static final String ASC_ORDERING = "asc";
    private static final Map<String, SearchQuery.Sort.SortClause> SORT_CLAUSE_MAP = ImmutableMap.builder().put((Object)"date", (Object)SearchQuery.Sort.SortClause.SentDate).put((Object)"id", (Object)SearchQuery.Sort.SortClause.Id).put((Object)"subject", (Object)SearchQuery.Sort.SortClause.BaseSubject).put((Object)"from", (Object)SearchQuery.Sort.SortClause.MailboxFrom).put((Object)"to", (Object)SearchQuery.Sort.SortClause.MailboxTo).put((Object)"size", (Object)SearchQuery.Sort.SortClause.Size).build();

    public static List<SearchQuery.Sort> convertToSorts(List<String> jmapSorts) {
        Preconditions.checkNotNull(jmapSorts);
        return (List)jmapSorts.stream().map(SortConverter::toSort).collect(ImmutableList.toImmutableList());
    }

    private static SearchQuery.Sort toSort(String jmapSort) {
        Preconditions.checkNotNull((Object)jmapSort);
        List splitToList = Splitter.on((String)SEPARATOR).splitToList((CharSequence)jmapSort);
        SortConverter.checkField(splitToList);
        return new SearchQuery.Sort(SortConverter.getSortClause((String)splitToList.get(0)), SortConverter.isReverse(splitToList));
    }

    private static SearchQuery.Sort.SortClause getSortClause(String field) {
        if (!SORT_CLAUSE_MAP.containsKey(field)) {
            throw new IllegalArgumentException("Unknown sorting field: " + field + " should be one of " + SORT_CLAUSE_MAP.keySet());
        }
        return SORT_CLAUSE_MAP.get(field);
    }

    private static SearchQuery.Sort.Order isReverse(List<String> splitList) {
        String order;
        if (splitList.size() == 1) {
            return SearchQuery.Sort.Order.REVERSE;
        }
        switch (order = splitList.get(1)) {
            case "desc": {
                return SearchQuery.Sort.Order.REVERSE;
            }
            case "asc": {
                return SearchQuery.Sort.Order.NATURAL;
            }
        }
        throw new IllegalArgumentException("Unknown sorting order: " + order + " should be one of [asc, desc]");
    }

    private static void checkField(List<String> splitToList) {
        Preconditions.checkArgument((splitToList.size() > 0 && splitToList.size() <= 2 ? 1 : 0) != 0, (Object)"Bad sort field definition. Must contains a field and an optional order separated by a space");
    }
}

