/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.GetVacationRequest;
import org.apache.james.jmap.draft.model.GetVacationResponse;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.VacationResponse;
import org.apache.james.jmap.draft.utils.AccountIdUtil;
import org.apache.james.jmap.http.LoggingHelper;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class GetVacationResponseMethod
implements Method {
    public static final Method.Request.Name METHOD_NAME = Method.Request.name("getVacationResponse");
    public static final Method.Response.Name RESPONSE_NAME = Method.Response.name("vacationResponse");
    private final VacationService vacationService;
    private final ZonedDateTimeProvider zonedDateTimeProvider;
    private final MetricFactory metricFactory;

    @Inject
    public GetVacationResponseMethod(VacationService vacationService, ZonedDateTimeProvider zonedDateTimeProvider, MetricFactory metricFactory) {
        this.vacationService = vacationService;
        this.zonedDateTimeProvider = zonedDateTimeProvider;
        this.metricFactory = metricFactory;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return GetVacationRequest.class;
    }

    @Override
    public Flux<JmapResponse> process(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)methodCallId);
        Preconditions.checkNotNull((Object)mailboxSession);
        Preconditions.checkArgument((boolean)(request instanceof GetVacationRequest));
        return Flux.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-" + METHOD_NAME.getName(), (Publisher)this.process(mailboxSession).map(response -> JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).response((Method.Response)response).build()).flux())).contextWrite((ContextView)LoggingHelper.jmapAction("VACATION"));
    }

    private Mono<GetVacationResponse> process(MailboxSession mailboxSession) {
        return this.vacationService.retrieveVacation(AccountIdUtil.toVacationAccountId(AccountId.fromUsername((Username)mailboxSession.getUser()))).map(vacation -> this.asVacationResponse(mailboxSession, (Vacation)vacation));
    }

    private GetVacationResponse asVacationResponse(MailboxSession mailboxSession, Vacation vacation) {
        return GetVacationResponse.builder().accountId(mailboxSession.getUser().asString()).vacationResponse(VacationResponse.builder().fromVacation(vacation).activated(vacation.isActiveAtDate((ZonedDateTime)this.zonedDateTimeProvider.get())).build()).build();
    }
}

