/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.apache.james.events.Event;
import org.apache.james.events.EventBusName;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.events.GroupAlreadyRegistered;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationKey;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface EventBus {
    public static final int EXECUTION_RATE = 10;

    default public Publisher<Registration> register(EventListener listener, RegistrationKey key) {
        return this.register(EventListener.wrapReactive(listener), key);
    }

    public Publisher<Registration> register(EventListener.ReactiveEventListener var1, RegistrationKey var2);

    default public Publisher<Registration> register(EventListener.ReactiveEventListener listener, Collection<RegistrationKey> keys) {
        return Flux.fromIterable(keys).concatMap(key -> this.register(listener, (RegistrationKey)key)).reduce((reg1, reg2) -> () -> Flux.merge((Publisher[])new Publisher[]{reg1.unregister(), reg2.unregister()})).map(unRegistrationWithMergedFlux -> () -> Mono.from((Publisher)Flux.from(unRegistrationWithMergedFlux.unregister()).then()));
    }

    public Registration register(EventListener.ReactiveEventListener var1, Group var2) throws GroupAlreadyRegistered;

    default public Registration register(EventListener listener, Group group) throws GroupAlreadyRegistered {
        return this.register(EventListener.wrapReactive(listener), group);
    }

    public Mono<Void> dispatch(Event var1, Set<RegistrationKey> var2);

    public Mono<Void> reDeliver(Group var1, Event var2);

    public EventBusName eventBusName();

    default public Mono<Void> dispatch(Event event, RegistrationKey key) {
        return this.dispatch(event, (Set<RegistrationKey>)ImmutableSet.of((Object)key));
    }

    default public Registration register(EventListener.GroupEventListener groupListener) {
        return this.register(EventListener.wrapReactive(groupListener));
    }

    default public Registration register(EventListener.ReactiveGroupEventListener groupListener) {
        return this.register((EventListener.ReactiveEventListener)groupListener, groupListener.getDefaultGroup());
    }

    default public Collection<Group> listRegisteredGroups() {
        return ImmutableList.of();
    }

    public static interface Metrics {
        public static String timerName(EventListener listener) {
            return "mailbox-listener-" + listener.getClass().getSimpleName();
        }
    }

    public static interface StructuredLoggingFields {
        public static final String EVENT_ID = "eventId";
        public static final String EVENT_CLASS = "eventClass";
        public static final String LISTENER_CLASS = "listenerClass";
        public static final String USER = "user";
        public static final String GROUP = "group";
        public static final String REGISTRATION_KEYS = "registrationKeys";
        public static final String REGISTRATION_KEY = "registrationKey";
    }
}

