/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.eventsourcing.acl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.ACLUpdated;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.MailboxAggregateId;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.SetACLCommand;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.UpdateACLCommand;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;

public class MailboxACLAggregate {
    private final MailboxAggregateId aggregateId;
    private final History history;
    private State state;

    public static MailboxACLAggregate load(MailboxAggregateId aggregateId, History history) {
        return new MailboxACLAggregate(aggregateId, history);
    }

    public MailboxACLAggregate(MailboxAggregateId aggregateId, History history) {
        this.aggregateId = aggregateId;
        this.history = history;
        this.state = State.initial();
        history.getEventsJava().forEach(this::apply);
    }

    public List<Event> deleteMailbox() {
        return ImmutableList.of((Object)new ACLUpdated(this.aggregateId, this.history.getNextEventId(), ACLDiff.computeDiff((MailboxACL)this.state.acl.orElse(MailboxACL.EMPTY), (MailboxACL)MailboxACL.EMPTY)));
    }

    public List<Event> set(SetACLCommand setACLCommand) {
        return ImmutableList.of((Object)new ACLUpdated(this.aggregateId, this.history.getNextEventId(), ACLDiff.computeDiff((MailboxACL)this.state.acl.orElse(MailboxACL.EMPTY), (MailboxACL)setACLCommand.getAcl())));
    }

    public List<Event> update(UpdateACLCommand command) throws UnsupportedRightException {
        MailboxACL oldACL = this.state.acl.orElse(MailboxACL.EMPTY);
        return ImmutableList.of((Object)new ACLUpdated(command.getId(), this.history.getNextEventId(), ACLDiff.computeDiff((MailboxACL)oldACL, (MailboxACL)oldACL.apply(command.getAclCommand()))));
    }

    private void apply(Event event) {
        if (event instanceof ACLUpdated) {
            ACLUpdated aclUpdated = (ACLUpdated)event;
            this.state = State.forAcl(aclUpdated.getAclDiff().getNewACL());
        }
    }

    private static class State {
        private final Optional<MailboxACL> acl;

        static State initial() {
            return new State(Optional.empty());
        }

        static State forAcl(MailboxACL acl) {
            return new State(Optional.of(acl));
        }

        private State(Optional<MailboxACL> acl) {
            this.acl = acl;
        }
    }
}

