/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;

final class CombinedDocValues {
    private final NumericDocValues versionDV;
    private final NumericDocValues seqNoDV;
    private final NumericDocValues primaryTermDV;
    private final NumericDocValues tombstoneDV;
    private final NumericDocValues recoverySource;

    CombinedDocValues(LeafReader leafReader) throws IOException {
        this.versionDV = Objects.requireNonNull(leafReader.getNumericDocValues("_version"), "VersionDV is missing");
        this.seqNoDV = Objects.requireNonNull(leafReader.getNumericDocValues("_seq_no"), "SeqNoDV is missing");
        this.primaryTermDV = Objects.requireNonNull(leafReader.getNumericDocValues("_primary_term"), "PrimaryTermDV is missing");
        this.tombstoneDV = leafReader.getNumericDocValues("_tombstone");
        this.recoverySource = leafReader.getNumericDocValues("_recovery_source");
    }

    long docVersion(int segmentDocId) throws IOException {
        assert (this.versionDV.docID() < segmentDocId);
        if (!this.versionDV.advanceExact(segmentDocId)) {
            assert (false) : "DocValues for field [_version] is not found";
            throw new IllegalStateException("DocValues for field [_version] is not found");
        }
        return this.versionDV.longValue();
    }

    long docSeqNo(int segmentDocId) throws IOException {
        assert (this.seqNoDV.docID() < segmentDocId);
        if (!this.seqNoDV.advanceExact(segmentDocId)) {
            assert (false) : "DocValues for field [_seq_no] is not found";
            throw new IllegalStateException("DocValues for field [_seq_no] is not found");
        }
        return this.seqNoDV.longValue();
    }

    long docPrimaryTerm(int segmentDocId) throws IOException {
        assert (this.primaryTermDV.docID() < segmentDocId);
        if (!this.primaryTermDV.advanceExact(segmentDocId)) {
            assert (false) : "DocValues for field [_primary_term] is not found";
            throw new IllegalStateException("DocValues for field [_primary_term] is not found");
        }
        return this.primaryTermDV.longValue();
    }

    boolean isTombstone(int segmentDocId) throws IOException {
        if (this.tombstoneDV == null) {
            return false;
        }
        assert (this.tombstoneDV.docID() < segmentDocId);
        return this.tombstoneDV.advanceExact(segmentDocId) && this.tombstoneDV.longValue() > 0L;
    }

    boolean hasRecoverySource(int segmentDocId) throws IOException {
        if (this.recoverySource == null) {
            return false;
        }
        assert (this.recoverySource.docID() < segmentDocId);
        return this.recoverySource.advanceExact(segmentDocId);
    }
}

