/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.net.InetAddresses;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class Domain
implements Serializable {
    private static final CharMatcher DASH_MATCHER = CharMatcher.anyOf((CharSequence)"-_");
    private static final CharMatcher DIGIT_MATCHER = CharMatcher.inRange((char)'0', (char)'9');
    private static final CharMatcher LETTER_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z'));
    private static final CharMatcher PART_CHAR_MATCHER = DIGIT_MATCHER.or(LETTER_MATCHER).or(DASH_MATCHER);
    public static final Domain LOCALHOST = Domain.of("localhost");
    public static final int MAXIMUM_DOMAIN_LENGTH = 253;
    private final String domainName;
    private final String normalizedDomainName;

    private static String removeBrackets(String domainName) {
        if (!domainName.startsWith("[") || !domainName.endsWith("]")) {
            return domainName;
        }
        return domainName.substring(1, domainName.length() - 1);
    }

    public static Domain of(String domain) {
        Preconditions.checkNotNull((Object)domain, (Object)"Domain can not be null");
        Preconditions.checkArgument((domain.length() <= 253 ? 1 : 0) != 0, (String)"Domain name length should not exceed %s characters", (int)253);
        String domainWithoutBrackets = Domain.removeBrackets(domain);
        List parts = Splitter.on((char)'.').splitToList((CharSequence)domainWithoutBrackets);
        parts.forEach(Domain::assertValidPart);
        Domain.assertValidLastPart((String)Iterables.getLast((Iterable)parts), domainWithoutBrackets);
        return new Domain(domainWithoutBrackets);
    }

    private static void assertValidPart(String domainPart) {
        Preconditions.checkArgument((!domainPart.isEmpty() ? 1 : 0) != 0, (Object)"Domain part should not be empty");
        Preconditions.checkArgument((!DASH_MATCHER.matches(domainPart.charAt(0)) ? 1 : 0) != 0, (Object)"Domain part should not start with '-' or '_'");
        Preconditions.checkArgument((!DASH_MATCHER.matches(domainPart.charAt(domainPart.length() - 1)) ? 1 : 0) != 0, (Object)"Domain part should not end with '-' or '_'");
        Preconditions.checkArgument((domainPart.length() <= 63 ? 1 : 0) != 0, (Object)"Domain part should not not exceed 63 characters");
        String asciiChars = CharMatcher.ascii().retainFrom((CharSequence)domainPart);
        Preconditions.checkArgument((boolean)PART_CHAR_MATCHER.matchesAllOf((CharSequence)asciiChars), (Object)"Domain parts ASCII chars must be a-z A-Z 0-9 - or _");
    }

    private static void assertValidLastPart(String domainPart, String domain) {
        boolean onlyDigits = DIGIT_MATCHER.matches(domainPart.charAt(0));
        boolean invalid = onlyDigits && !Domain.validIPAddress(domain);
        Preconditions.checkArgument((!invalid ? 1 : 0) != 0, (Object)"The k=last domain part must not start with 0-9");
    }

    private static boolean validIPAddress(String value) {
        try {
            InetAddresses.forString((String)value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected Domain(String domainName) {
        this.domainName = domainName;
        this.normalizedDomainName = Domain.removeBrackets(domainName.toLowerCase(Locale.US));
    }

    public String name() {
        return this.domainName;
    }

    public String asString() {
        return this.normalizedDomainName;
    }

    public final boolean equals(Object o) {
        if (o instanceof Domain) {
            Domain domain = (Domain)o;
            return Objects.equals(this.normalizedDomainName, domain.normalizedDomainName);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.normalizedDomainName);
    }

    public String toString() {
        return "Domain : " + this.domainName;
    }
}

