/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.client;

import java.util.Optional;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientManagerMetrics;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.factory.ThriftClientFactory;
import org.apache.iotdb.commons.client.property.ClientPoolProperty;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.protocol.client.ainode.AINodeClient;
import org.apache.iotdb.db.protocol.client.ainode.AsyncAINodeServiceClient;
import org.apache.thrift.transport.TTransport;

public class AINodeClientFactory
extends ThriftClientFactory<TEndPoint, AINodeClient> {
    private static final int connectionTimeout = CommonDescriptor.getInstance().getConfig().getDnConnectionTimeoutInMS();

    public AINodeClientFactory(ClientManager<TEndPoint, AINodeClient> manager, ThriftClientProperty thriftProperty) {
        super(manager, thriftProperty);
    }

    public PooledObject<AINodeClient> makeObject(TEndPoint endPoint) throws Exception {
        return new DefaultPooledObject((Object)new AINodeClient(this.thriftClientProperty, endPoint, (ClientManager<TEndPoint, AINodeClient>)this.clientManager));
    }

    public void destroyObject(TEndPoint key, PooledObject<AINodeClient> pooled) throws Exception {
        ((AINodeClient)pooled.getObject()).invalidate();
    }

    public boolean validateObject(TEndPoint key, PooledObject<AINodeClient> pooledObject) {
        return Optional.ofNullable(((AINodeClient)pooledObject.getObject()).getTransport()).map(TTransport::isOpen).orElse(false);
    }

    public static class AINodeHeartbeatClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncAINodeServiceClient> {
        public GenericKeyedObjectPool<TEndPoint, AsyncAINodeServiceClient> createClientPool(ClientManager<TEndPoint, AsyncAINodeServiceClient> manager) {
            CommonConfig conf = CommonDescriptor.getInstance().getConfig();
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncAINodeServiceClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getCnConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).setPrintLogWhenEncounterException(false).build(), ThreadName.ASYNC_DATANODE_HEARTBEAT_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }

    public static class AINodeClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AINodeClient> {
        public GenericKeyedObjectPool<TEndPoint, AINodeClient> createClientPool(ClientManager<TEndPoint, AINodeClient> manager) {
            ThriftClientProperty thriftProperty = new ThriftClientProperty.Builder().setConnectionTimeoutMs(connectionTimeout).setRpcThriftCompressionEnabled(CommonDescriptor.getInstance().getConfig().isRpcThriftCompressionEnabled()).build();
            GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AINodeClientFactory(manager, thriftProperty), new ClientPoolProperty.Builder().setMaxClientNumForEachNode(CommonDescriptor.getInstance().getConfig().getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), pool);
            return pool;
        }
    }
}

