/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.SimpleProgressIndex;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class RecoverProgressIndex
extends ProgressIndex {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(RecoverProgressIndex.class) + ProgressIndex.LOCK_SIZE;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Integer, SimpleProgressIndex> dataNodeId2LocalIndex;

    private RecoverProgressIndex() {
        this(Collections.emptyMap());
    }

    public RecoverProgressIndex(int dataNodeId, SimpleProgressIndex simpleProgressIndex) {
        this(Collections.singletonMap(dataNodeId, simpleProgressIndex));
    }

    public RecoverProgressIndex(Map<Integer, SimpleProgressIndex> dataNodeId2LocalIndex) {
        this.dataNodeId2LocalIndex = new HashMap<Integer, SimpleProgressIndex>(dataNodeId2LocalIndex);
    }

    public Map<Integer, SimpleProgressIndex> getDataNodeId2LocalIndex() {
        return ImmutableMap.copyOf(this.dataNodeId2LocalIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.RECOVER_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write((int)this.dataNodeId2LocalIndex.size(), (ByteBuffer)byteBuffer);
            for (Map.Entry<Integer, SimpleProgressIndex> entry : this.dataNodeId2LocalIndex.entrySet()) {
                ReadWriteIOUtils.write((int)entry.getKey(), (ByteBuffer)byteBuffer);
                entry.getValue().serialize(byteBuffer);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.RECOVER_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write((int)this.dataNodeId2LocalIndex.size(), (OutputStream)stream);
            for (Map.Entry<Integer, SimpleProgressIndex> entry : this.dataNodeId2LocalIndex.entrySet()) {
                ReadWriteIOUtils.write((int)entry.getKey(), (OutputStream)stream);
                entry.getValue().serialize(stream);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfter(@Nonnull ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = true;
                return bl;
            }
            if (progressIndex instanceof HybridProgressIndex) {
                boolean bl = ((HybridProgressIndex)progressIndex).isGivenProgressIndexAfterSelf(this);
                return bl;
            }
            if (!(progressIndex instanceof RecoverProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            RecoverProgressIndex thisRecoverProgressIndex = this;
            RecoverProgressIndex thatRecoverProgressIndex = (RecoverProgressIndex)progressIndex;
            boolean bl = thatRecoverProgressIndex.dataNodeId2LocalIndex.entrySet().stream().noneMatch(entry -> !thisRecoverProgressIndex.dataNodeId2LocalIndex.containsKey(entry.getKey()) || !thisRecoverProgressIndex.dataNodeId2LocalIndex.get(entry.getKey()).isAfter((ProgressIndex)entry.getValue()));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (!(progressIndex instanceof RecoverProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            RecoverProgressIndex thisRecoverProgressIndex = this;
            RecoverProgressIndex thatRecoverProgressIndex = (RecoverProgressIndex)progressIndex;
            boolean bl = thisRecoverProgressIndex.dataNodeId2LocalIndex.size() == thatRecoverProgressIndex.dataNodeId2LocalIndex.size() && thatRecoverProgressIndex.dataNodeId2LocalIndex.entrySet().stream().allMatch(entry -> thisRecoverProgressIndex.dataNodeId2LocalIndex.containsKey(entry.getKey()) && thisRecoverProgressIndex.dataNodeId2LocalIndex.get(entry.getKey()).equals((ProgressIndex)entry.getValue()));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RecoverProgressIndex)) {
            return false;
        }
        return this.equals((RecoverProgressIndex)obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dataNodeId2LocalIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressIndex updateToMinimumEqualOrIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            if (!(progressIndex instanceof RecoverProgressIndex)) {
                ProgressIndex progressIndex2 = ProgressIndex.blendProgressIndex(this, progressIndex);
                return progressIndex2;
            }
            RecoverProgressIndex thisRecoverProgressIndex = this;
            RecoverProgressIndex thatRecoverProgressIndex = (RecoverProgressIndex)progressIndex;
            HashMap<Integer, SimpleProgressIndex> dataNodeId2LocalIndex = new HashMap<Integer, SimpleProgressIndex>(thisRecoverProgressIndex.dataNodeId2LocalIndex);
            thatRecoverProgressIndex.dataNodeId2LocalIndex.forEach((thatK, thatV) -> dataNodeId2LocalIndex.compute((Integer)thatK, (thisK, thisV) -> thisV == null ? thatV : (SimpleProgressIndex)thisV.updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)thatV)));
            RecoverProgressIndex recoverProgressIndex = new RecoverProgressIndex(dataNodeId2LocalIndex);
            return recoverProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.RECOVER_PROGRESS_INDEX;
    }

    @Override
    public ProgressIndex.TotalOrderSumTuple getTotalOrderSumTuple() {
        this.lock.readLock().lock();
        try {
            ProgressIndex.TotalOrderSumTuple totalOrderSumTuple = ProgressIndex.TotalOrderSumTuple.sum(this.dataNodeId2LocalIndex.values().stream().map(SimpleProgressIndex::getTotalOrderSumTuple).collect(Collectors.toList()));
            return totalOrderSumTuple;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static RecoverProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        RecoverProgressIndex recoverProgressIndex = new RecoverProgressIndex();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            int dataNodeId = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            SimpleProgressIndex simpleProgressIndex = (SimpleProgressIndex)ProgressIndexType.deserializeFrom(byteBuffer);
            recoverProgressIndex.dataNodeId2LocalIndex.put(dataNodeId, simpleProgressIndex);
        }
        return recoverProgressIndex;
    }

    public static RecoverProgressIndex deserializeFrom(InputStream stream) throws IOException {
        RecoverProgressIndex recoverProgressIndex = new RecoverProgressIndex();
        int size = ReadWriteIOUtils.readInt((InputStream)stream);
        for (int i = 0; i < size; ++i) {
            int dataNodeId = ReadWriteIOUtils.readInt((InputStream)stream);
            SimpleProgressIndex simpleProgressIndex = (SimpleProgressIndex)ProgressIndexType.deserializeFrom(stream);
            recoverProgressIndex.dataNodeId2LocalIndex.put(dataNodeId, simpleProgressIndex);
        }
        return recoverProgressIndex;
    }

    public String toString() {
        return "RecoverProgressIndex{dataNodeId2LocalIndex=" + this.dataNodeId2LocalIndex + '}';
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + (long)this.dataNodeId2LocalIndex.size() * RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + this.dataNodeId2LocalIndex.values().stream().map(SimpleProgressIndex::ramBytesUsed).reduce(0L, Long::sum);
    }
}

