/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.type;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.apache.tsfile.utils.Binary;

public enum Type {
    BOOLEAN(0),
    INT32(1),
    INT64(2),
    FLOAT(3),
    DOUBLE(4),
    TEXT(5),
    TIMESTAMP(8),
    DATE(9),
    BLOB(10),
    STRING(11);

    private final byte dataType;

    private Type(byte type) {
        this.dataType = type;
    }

    public byte getType() {
        return this.dataType;
    }

    public static Type valueOf(byte type) {
        for (Type t2 : Type.values()) {
            if (t2.dataType != type) continue;
            return t2;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public boolean checkObjectType(Object o) {
        switch (this) {
            case BOOLEAN: {
                return o instanceof Boolean;
            }
            case INT32: {
                return o instanceof Integer;
            }
            case INT64: 
            case TIMESTAMP: {
                return o instanceof Long;
            }
            case FLOAT: {
                return o instanceof Float;
            }
            case DOUBLE: {
                return o instanceof Double;
            }
            case DATE: {
                return o instanceof LocalDate;
            }
            case BLOB: {
                return o instanceof Binary;
            }
            case STRING: 
            case TEXT: {
                return o instanceof String;
            }
        }
        return false;
    }

    public static List<Type> allTypes() {
        return Arrays.asList(BOOLEAN, INT32, INT64, FLOAT, DOUBLE, TEXT, TIMESTAMP, DATE, BLOB, STRING);
    }

    public static List<Type> numericTypes() {
        return Arrays.asList(INT32, INT64, FLOAT, DOUBLE);
    }
}

