/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.function.BoundSignature;
import org.apache.iotdb.db.queryengine.plan.relational.function.FunctionId;
import org.apache.iotdb.db.queryengine.plan.relational.function.FunctionKind;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.FunctionNullability;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ResolvedFunction {
    private final BoundSignature signature;
    private final FunctionId functionId;
    private final FunctionKind functionKind;
    private final boolean deterministic;
    private final FunctionNullability functionNullability;

    public ResolvedFunction(BoundSignature signature, FunctionId functionId, FunctionKind functionKind, boolean deterministic, FunctionNullability functionNullability) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.functionKind = Objects.requireNonNull(functionKind, "functionKind is null");
        this.deterministic = deterministic;
        this.functionNullability = Objects.requireNonNull(functionNullability, "functionNullability is null");
    }

    public BoundSignature getSignature() {
        return this.signature;
    }

    public FunctionId getFunctionId() {
        return this.functionId;
    }

    public FunctionKind getFunctionKind() {
        return this.functionKind;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public FunctionNullability getFunctionNullability() {
        return this.functionNullability;
    }

    public QualifiedName toQualifiedName() {
        return QualifiedName.of(this.signature.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedFunction that = (ResolvedFunction)o;
        return Objects.equals(this.signature, that.signature) && Objects.equals(this.functionId, that.functionId) && this.functionKind == that.functionKind && this.deterministic == that.deterministic;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.functionId, this.functionKind, this.deterministic});
    }

    public String toString() {
        return this.signature.toString();
    }

    public void serialize(ByteBuffer byteBuffer) {
        this.signature.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.functionId.toString(), (ByteBuffer)byteBuffer);
        this.functionKind.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.deterministic, (ByteBuffer)byteBuffer);
        this.functionNullability.serialize(byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        this.signature.serialize(stream);
        ReadWriteIOUtils.write((String)this.functionId.toString(), (OutputStream)stream);
        this.functionKind.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.deterministic, (OutputStream)stream);
        this.functionNullability.serialize(stream);
    }

    public static ResolvedFunction deserialize(ByteBuffer byteBuffer) {
        BoundSignature signature = BoundSignature.deserialize(byteBuffer);
        FunctionId functionId = new FunctionId(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        FunctionKind functionKind = FunctionKind.deserialize(byteBuffer);
        boolean deterministic = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        FunctionNullability functionNullability = FunctionNullability.deserialize(byteBuffer);
        return new ResolvedFunction(signature, functionId, functionKind, deterministic, functionNullability);
    }
}

