/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.layer;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.dataset.IUDFInputDataSet;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.db.query.udf.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class LayerCacheUtils {
    private LayerCacheUtils() {
    }

    public static int cachePoints(TSDataType dataType, LayerPointReader source, ElasticSerializableTVList target, int pointNumber) throws QueryProcessException, IOException {
        int count;
        for (count = 0; count < pointNumber && LayerCacheUtils.cachePoint(dataType, source, target); ++count) {
        }
        return count;
    }

    public static boolean cachePoint(TSDataType dataType, LayerPointReader source, ElasticSerializableTVList target) throws IOException, QueryProcessException {
        if (!source.next()) {
            return false;
        }
        if (source.isCurrentNull()) {
            target.putNull(source.currentTime());
        } else {
            switch (dataType) {
                case INT32: {
                    target.putInt(source.currentTime(), source.currentInt());
                    break;
                }
                case INT64: {
                    target.putLong(source.currentTime(), source.currentLong());
                    break;
                }
                case FLOAT: {
                    target.putFloat(source.currentTime(), source.currentFloat());
                    break;
                }
                case DOUBLE: {
                    target.putDouble(source.currentTime(), source.currentDouble());
                    break;
                }
                case BOOLEAN: {
                    target.putBoolean(source.currentTime(), source.currentBoolean());
                    break;
                }
                case TEXT: {
                    target.putBinary(source.currentTime(), source.currentBinary());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(dataType.name());
                }
            }
        }
        source.readyForNext();
        return true;
    }

    public static int cacheRows(IUDFInputDataSet source, ElasticSerializableRowRecordList target, int rowsNumber) throws QueryProcessException, IOException {
        int count;
        for (count = 0; count < rowsNumber && LayerCacheUtils.cacheRow(source, target); ++count) {
        }
        return count;
    }

    public static boolean cacheRow(IUDFInputDataSet source, ElasticSerializableRowRecordList target) throws IOException, QueryProcessException {
        if (source.hasNextRowInObjects()) {
            target.put(source.nextRowInObjects());
            return true;
        }
        return false;
    }
}

