/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDTableHashmapImpl;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDTableManager {
    Logger logger = LoggerFactory.getLogger(IDTableManager.class);
    HashMap<String, IDTable> idTableMap;
    private final String systemDir = FilePathUtils.regularizePath((String)IoTDBDescriptor.getInstance().getConfig().getSystemDir()) + "storage_groups";

    public static IDTableManager getInstance() {
        return IDManagerHolder.INSTANCE;
    }

    private IDTableManager() {
        this.idTableMap = new HashMap();
    }

    public synchronized IDTable getIDTable(PartialPath devicePath) {
        try {
            IStorageGroupMNode storageGroupMNode = IoTDB.metaManager.getStorageGroupNodeByPath(devicePath);
            return this.idTableMap.computeIfAbsent(storageGroupMNode.getFullPath(), storageGroupPath -> new IDTableHashmapImpl(SystemFileFactory.INSTANCE.getFile(this.systemDir + File.separator + storageGroupPath)));
        }
        catch (MetadataException e) {
            this.logger.error("get id table failed, path is: " + devicePath + ". caused by: " + e);
            return null;
        }
    }

    public void clear() throws IOException {
        for (IDTable idTable : this.idTableMap.values()) {
            idTable.clear();
        }
        this.idTableMap.clear();
    }

    private static class IDManagerHolder {
        private static final IDTableManager INSTANCE = new IDTableManager();

        private IDManagerHolder() {
        }
    }
}

