/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.placementdriver.metrics;

import java.util.List;
import java.util.function.IntSupplier;
import org.apache.ignite3.internal.metrics.AbstractMetricSource;
import org.apache.ignite3.internal.metrics.IntGauge;
import org.apache.ignite3.internal.metrics.IntMetric;
import org.apache.ignite3.internal.metrics.LongAdderMetric;
import org.apache.ignite3.internal.metrics.Metric;

public class PlacementDriverMetricSource
extends AbstractMetricSource<Holder> {
    public static final String SOURCE_NAME = "placement-driver";
    private final IntSupplier activeLeaseSupplier;
    private final IntSupplier leaseWithoutCandidatesSupplier;
    private final IntSupplier currentStableAssignmentSizeSupplier;
    private final IntSupplier currentPendingAssignmentSizeSupplier;

    public PlacementDriverMetricSource(IntSupplier activeLeaseSupplier, IntSupplier leaseWithoutCandidatesSupplier, IntSupplier currentStableAssignmentSizeSupplier, IntSupplier currentPendingAssignmentSizeSupplier) {
        super(SOURCE_NAME, "Placement driver metrics.");
        this.activeLeaseSupplier = activeLeaseSupplier;
        this.leaseWithoutCandidatesSupplier = leaseWithoutCandidatesSupplier;
        this.currentStableAssignmentSizeSupplier = currentStableAssignmentSizeSupplier;
        this.currentPendingAssignmentSizeSupplier = currentPendingAssignmentSizeSupplier;
    }

    @Override
    protected Holder createHolder() {
        return new Holder();
    }

    public void onLeaseCreate() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.leasesCreated.increment();
        }
    }

    public void onLeaseProlong() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.leasesProlonged.increment();
        }
    }

    public void onLeasePublish() {
        Holder holder = (Holder)this.holder();
        if (holder != null) {
            holder.leasesPublished.increment();
        }
    }

    protected class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final LongAdderMetric leasesCreated = new LongAdderMetric("LeasesCreated", "Total number of created leases.");
        private final LongAdderMetric leasesPublished = new LongAdderMetric("LeasesPublished", "Total number of published leases.");
        private final LongAdderMetric leasesProlonged = new LongAdderMetric("LeasesProlonged", "Total number of prolonged leases.");
        private final IntMetric activeLeaseCount;
        private final IntMetric leaseWithoutCandidates;
        private final IntMetric currentStableAssignmentSize;
        private final IntMetric currentPendingAssignmentSize;
        private final List<Metric> metrics;

        protected Holder() {
            this.activeLeaseCount = new IntGauge("ActiveLeasesCount", "Number of currently active leases.", PlacementDriverMetricSource.this.activeLeaseSupplier);
            this.leaseWithoutCandidates = new IntGauge("LeasesWithoutCandidates", "Number of leases without candidates currently existing.", PlacementDriverMetricSource.this.leaseWithoutCandidatesSupplier);
            this.currentStableAssignmentSize = new IntGauge("CurrentStableAssignmentsSize", "Current size of stable assignments over all partitions.", PlacementDriverMetricSource.this.currentStableAssignmentSizeSupplier);
            this.currentPendingAssignmentSize = new IntGauge("CurrentPendingAssignmentsSize", "Current size of pending assignments over all partitions.", PlacementDriverMetricSource.this.currentPendingAssignmentSizeSupplier);
            this.metrics = List.of(this.leasesCreated, this.leasesPublished, this.leasesProlonged, this.leaseWithoutCandidates, this.activeLeaseCount, this.currentStableAssignmentSize, this.currentPendingAssignmentSize);
        }

        @Override
        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

