/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.instruction;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.instruction.InstructionNode;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class VariableInstruction
implements InstructionNode {
    private final Variable variable;

    public static InstructionNode loadVariable(Variable variable) {
        return new LoadVariableInstruction(variable);
    }

    public static InstructionNode storeVariable(Variable variable) {
        return new StoreVariableInstruction(variable);
    }

    public static InstructionNode incrementVariable(Variable variable, byte increment) {
        return new IncrementVariableInstruction(variable, increment);
    }

    private VariableInstruction(Variable variable) {
        this.variable = variable;
    }

    public Variable getVariable() {
        return this.variable;
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of();
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitVariableInstruction(parent, this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{variable=" + String.valueOf(this.variable) + "}";
    }

    public static class LoadVariableInstruction
    extends VariableInstruction {
        public LoadVariableInstruction(Variable variable) {
            super(variable);
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            visitor.visitVarInsn(Type.getType((String)this.getVariable().getType().getType()).getOpcode(OpCode.ILOAD.getOpCode()), generationContext.getVariableSlot(this.getVariable()));
        }

        @Override
        public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
            return visitor.visitLoadVariable(parent, this);
        }
    }

    public static class StoreVariableInstruction
    extends VariableInstruction {
        public StoreVariableInstruction(Variable variable) {
            super(variable);
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            visitor.visitVarInsn(Type.getType((String)this.getVariable().getType().getType()).getOpcode(OpCode.ISTORE.getOpCode()), generationContext.getVariableSlot(this.getVariable()));
        }

        @Override
        public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
            return visitor.visitStoreVariable(parent, this);
        }
    }

    public static class IncrementVariableInstruction
    extends VariableInstruction {
        private final byte increment;

        public IncrementVariableInstruction(Variable variable, byte increment) {
            super(variable);
            String type = variable.getType().getClassName();
            BytecodeUtils.checkArgument(List.of("byte", "short", "int").contains(type), "variable must be an byte, short or int, but is %s", type);
            this.increment = increment;
        }

        public byte getIncrement() {
            return this.increment;
        }

        @Override
        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            visitor.visitIincInsn(generationContext.getVariableSlot(this.getVariable()), (int)this.increment);
        }

        @Override
        public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
            return visitor.visitIncrementVariable(parent, this);
        }
    }
}

