/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;

public class OptimizedStream
extends DirectByteBufferStreamImplV1 {
    private static final int[] MASKS_32 = new int[]{0, 0, -128, 16256, -2080896, 266354560};
    private static final long[] MASKS_64 = new long[]{0L, 0L, -128L, 16256L, -2080896L, 266354560L, -34093383808L, 4363953127296L, -558586000294016L, 71499008037633920L, -9151873028817141888L};

    public OptimizedStream(MessageSerializationRegistry serializationRegistry) {
        super(serializationRegistry);
        this.lastFinished = true;
    }

    public short readShort() {
        return (short)this.readInt();
    }

    public int readInt() {
        byte b;
        int pos;
        int res = 0;
        int arrayOffset = this.buf.arrayOffset();
        int startPos = pos = this.buf.position();
        if ((b = this.heapArr[arrayOffset + pos++]) >= 0) {
            this.setPosition(pos);
            return b - 1;
        }
        int shift = 0;
        while (true) {
            res ^= b << shift;
            if (b >= 0) {
                this.setPosition(pos);
                return (res ^= MASKS_32[pos - startPos]) - 1;
            }
            b = this.heapArr[arrayOffset + pos++];
            shift += 7;
        }
    }

    public long readLong() {
        int pos;
        long res = 0L;
        int arrayOffset = this.buf.arrayOffset();
        int startPos = pos = this.buf.position();
        int shift = 0;
        while (true) {
            long b = this.heapArr[arrayOffset + pos++];
            res ^= b << shift;
            if (b >= 0L) {
                this.setPosition(pos);
                return (res ^= MASKS_64[pos - startPos]) - 1L;
            }
            shift += 7;
        }
    }

    public String readString() {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        int pos = this.buf.position();
        this.setPosition(pos + len);
        return new String(this.heapArr, this.buf.arrayOffset() + pos, len, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer readByteBuffer() {
        assert (this.buf.hasArray());
        byte flag = this.readByte();
        if ((flag & 1) == 0) {
            return null;
        }
        int length = this.readInt();
        int oldLimit = this.buf.limit();
        try {
            ByteBuffer val = this.buf.limit(this.buf.position() + length).slice();
            this.buf.position(this.buf.limit());
            if ((flag & 2) == 0) {
                val.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                val.order(ByteOrder.BIG_ENDIAN);
            }
            ByteBuffer byteBuffer = val;
            return byteBuffer;
        }
        finally {
            this.buf.limit(oldLimit);
        }
    }
}

