/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.LongGauge;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.pagememory.persistence.store.GroupPageStoresMap;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryStorageMetricSource;

class PersistentPageMemoryStorageMetrics {
    private static final IgniteLogger LOG = Loggers.forClass(PersistentPageMemoryStorageMetrics.class);

    PersistentPageMemoryStorageMetrics() {
    }

    static void initMetrics(PersistentPageMemoryStorageMetricSource source, FilePageStoreManager filePageStoreManager) {
        source.addMetric(new LongGauge("StorageSize", "Size of the entire storage in bytes.", () -> PersistentPageMemoryStorageMetrics.storageSize(filePageStoreManager)));
    }

    private static long storageSize(FilePageStoreManager filePageStoreManager) {
        return filePageStoreManager.allPageStores().mapToLong(PersistentPageMemoryStorageMetrics::fullSize).sum();
    }

    private static long fullSize(GroupPageStoresMap.GroupPartitionPageStore<FilePageStore> pageStore) {
        try {
            return ((FilePageStore)pageStore.pageStore()).fullSize();
        }
        catch (IgniteInternalCheckedException e) {
            LOG.warn("Error getting storage size: [groupPartitionId={}]", (Throwable)e, new Object[]{pageStore.groupPartitionId()});
            return 0L;
        }
    }
}

